package com.digiwin.mobile.mobileuibot.mysql;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.model.db1.PushLog;
import com.digiwin.mobile.mobileuibot.mysql.model.PushLogRequest;
import com.digiwin.mobile.mobileuibot.mysql.service.PushLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 推送日志接口
 *
 * @author zhangjj
 * @date 2022/10/11 17:01
 */
@RestController
@RequestMapping(value = "/mobile/v1/push/log")
public class PushLogController {

    @Autowired
    private PushLogService pushLogService;

    /**
     * 新增推送日志
     *
     * @param pushLogRequest
     * @return
     */
    @PostMapping(value = "/add")
    public ApiResponse addPushLog(@RequestBody PushLogRequest pushLogRequest) {
        String deviceType = pushLogRequest.getDeviceType();
        String clientId = pushLogRequest.getClientId();
        List<PushLog> pushLogList = pushLogRequest.getOperationList();
        pushLogList.forEach(pushLog -> {
            pushLog.setClientId(clientId);
            pushLog.setDeviceType(deviceType);
        });
        pushLogService.insertPushLog(pushLogList);
        return ApiResponse.buildOK();
    }

}
