package com.digiwin.mobile.mobileuibot.mysql.service;


import com.digiwin.mobile.mobileuibot.model.db1.AppExpireNoticeRecord;

import java.util.List;
import java.util.Map;

/**
 * 应用到期提醒
 *
 * @author xujin
 */
public interface AppExpireNoticeRecordService {

    /**
     * 根据 userid、tenantId 获取数据
     *
     * @param params
     * @return
     */
    List<AppExpireNoticeRecord> getInfo(Map<String, String> params);

    /**
     * 批量插入数据
     *
     * @param itemList 实体类
     * @return
     */
    Boolean batchInsertData(List<AppExpireNoticeRecord> itemList);

    /**
     * 根据userid、tenantId删除对应数据
     *
     * @return
     */
    Boolean deleteData(Map<String, String> params);

    /**
     * 根据userid、tenantId 和 gids 删除对应数据
     *
     * @return
     */
    Boolean deleteDataByGid(Map<String, Object> params);

    /**
     * 删除所有数据
     *
     * @return
     */
    Boolean deleteAllData();
}
