package com.digiwin.mobile.mobileuibot.mysql.service;

import com.digiwin.mobile.mobileuibot.model.db1.UserProjectFilter;

/**
 * <p>功能描述：用户项目配置设置表 Service</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserProjectFilterService.java
 * @Author: wangjwc
 * @Date: created at 2024/7/24 13:15
 */
public interface UserProjectFilterService {

    /**
     * 查看是否有对应筛选记录
     *
     * @param userId
     * @param tenantId
     * @param pageFilterCode
     * @return
     * @see com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum
     */
    UserProjectFilter selectByParams(String userId, String tenantId, String pageFilterCode);

    /**
     * 新增或者更新用户搜索的记录
     *
     * @param userId
     * @param tenantId
     * @param pageFilterCode
     * @param queryParam
     * @see com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum
     */
    void modifyByQueryParam(String userId, String tenantId, String pageFilterCode, String queryParam);

    /**
     * 新增或者更新用户分组的记录
     *
     * @param userId
     * @param tenantId
     * @param pageFilterCode
     * @param groupFilter
     * @see com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum
     */
    void modifyByGroupFilter(String userId, String tenantId, String pageFilterCode, String groupFilter);
}
