package com.digiwin.mobile.mobileuibot.mysql.service;

import com.digiwin.mobile.mobileuibot.model.db1.UserTaskFilter;

/**
 * 用户任务卡筛选Service
 *
 * @author zhangjj
 * @date 2022/10/11 16:06
 */
public interface UserTaskFilterService {

    /**
     * 新增用户筛选任务卡的记录
     *
     * @param userTaskFilter
     * @param queryParam
     * @param filterIds
     */
    Boolean insertUserTaskFilter(UserTaskFilter userTaskFilter, String queryParam, String filterIds);

    /**
     * 查看是否有对应筛选记录
     *
     * @param userTaskFilter
     * @return
     */
    UserTaskFilter getUserTaskFilterByParams(UserTaskFilter userTaskFilter);

    /**
     * 新增或者更新用户搜索的记录
     *
     * @param userTaskFilter
     * @param queryParam
     * @return
     */
    Boolean insertUserTaskFilterByQueryParam(UserTaskFilter userTaskFilter, String queryParam);

    /**
     * 新增或者更新用户筛选的记录
     *
     * @param userTaskFilter
     * @param filterIds
     * @return
     */
    Boolean insertUserTaskFilterByFilterIds(UserTaskFilter userTaskFilter, String filterIds);


    /**
     * 新增或者更新用户分组的记录
     *
     * @param userTaskFilter
     * @param groupFilterIds
     * @return
     */
    Boolean insertUserTaskFilterByGroupFilterIds(UserTaskFilter userTaskFilter, String groupFilterIds);

    /**
     * 新增或者更新用户排序的记录
     *
     * @param userTaskFilter
     * @param sortFilterIds
     * @return
     */
    Boolean insertUserTaskFilterBySortFilterIds(UserTaskFilter userTaskFilter, String sortFilterIds);

    /**
     * 新增或者更新用户普通筛选的记录
     *
     * @param userTaskFilter
     * @param commonFilter
     * @return
     */
    Boolean insertUserTaskFilterByCommonFilter(UserTaskFilter userTaskFilter, String commonFilter);

    /**
     * 新增或者更新用户高级筛选的记录
     *
     * @param userTaskFilter
     * @param seniorFilter
     * @return
     */
    Boolean insertUserTaskFilterBySeniorFilter(UserTaskFilter userTaskFilter, String seniorFilter);
}
