package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.mapper.db1.OuterRequestRecordMapper;
import com.digiwin.mobile.mobileuibot.model.db1.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.OuterRequestRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;

/**
 * @author zhangjj
 * @date 2022/4/28 16:18
 */
@Slf4j
@Service
public class OuterRequestRecordServiceImpl extends ServiceImpl<OuterRequestRecordMapper, OuterRequestRecord> implements OuterRequestRecordService {

    @Autowired
    private OuterRequestRecordService outerRequestRecordService;

    @Autowired
    private OuterRequestRecordMapper outerRequestRecordMapper;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Override
    public void batchInsert(List<OuterRequestRecord> list) {
        if (sysEnvConfig.getSwitchOuterRequestRecord()) {
            outerRequestRecordService.saveBatch(list);
        }
    }

    @Override
    public void clear(int reserveDays) {
        log.debug("线程{}:清理outer_request_record表数据 -- begin", Thread.currentThread().getName());
        String currentDate = DateTimeUtil.getTodayTimeUseDefaultPattern();

        // 已经删除数据量
        long totalDeleted = 0L;
        // 开始时间
        Long begin = System.currentTimeMillis();

        try {
            Timestamp requestTime = new Timestamp(LocalDate.now().minus(reserveDays, ChronoUnit.DAYS)
                    .atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli());
            // 循环批量删除
            while (true) {
                List<String> idList = outerRequestRecordMapper.selectIdByCondition(requestTime, 1000);
                if (CollectionUtils.isEmpty(idList)) {
                    break;
                }
                int result = outerRequestRecordMapper.batchDeleteByIds(idList);
                // 已经删除条数
                totalDeleted += result;
            }
        } catch (Exception e) {
            log.error("线程{}:清理outer_request_record表数据 error:", Thread.currentThread().getName(), e);
        }
        // 结束时间
        Long end = System.currentTimeMillis();
        log.debug("线程{}:清理outer_request_record表数据 -- end,当前时间:{},预留{}天数据,删除{}条数据,耗时{}s",
                Thread.currentThread().getName(), currentDate, reserveDays, totalDeleted, (end - begin) / 1000);
    }
}
