package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.digiwin.mobile.mobileuibot.mapper.db1.PersonalConfigurationMapper;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.mysql.service.PersonalConfigurationService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author wuyang
 */
@Service("personalConfigurationService")
public class PersonalConfigurationServiceImpl implements PersonalConfigurationService {

    @Resource
    private PersonalConfigurationMapper personalConfigurationMapper;

    @Override
    public PersonalConfiguration getByMap(Map<String, String> params) {
        return personalConfigurationMapper.getByMap(params);
    }

    @Override
    public Boolean insertOrUpdate(PersonalConfiguration personalConfiguration) {
        // 先获取数据是否存在
        Map<String, String> params = new HashMap<>(2);
        params.put("userId", personalConfiguration.getUserId());
        params.put("tenantId", personalConfiguration.getTenantId());
        PersonalConfiguration byMap = this.getByMap(params);

        Date currentTime = new Date(System.currentTimeMillis());
        personalConfiguration.setUpdateTime(currentTime);
        if (null == byMap) {
            // 新增
            personalConfiguration.setCreateTime(currentTime);
            return personalConfigurationMapper.insertData(personalConfiguration);
        }
        // 修改
        personalConfiguration.setId(byMap.getId());
        return personalConfigurationMapper.updateData(personalConfiguration);
    }
}
