package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.mapper.db1.UserCardListFilterMapper;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author yanfeng
 * @date 2024/4/20
 */
@Service
public class UserCardListFilterServiceImpl extends ServiceImpl<UserCardListFilterMapper, UserCardListFilter> implements UserCardListFilterService {
    @Autowired
    private UserCardListFilterMapper userCardListFilterMapper;

    @Override
    public void insertOrUpdateUserCardListFilter(UserCardListFilter userCardListFilter) {
        LambdaQueryWrapper<UserCardListFilter> queryWrapper = handleQueryWrapper(userCardListFilter.getUserId(), userCardListFilter.getComponentId(), userCardListFilter.getPageId()
                , userCardListFilter.getTenantId(), userCardListFilter.getTmActivityId(), userCardListFilter.getDataId());
        UserCardListFilter entityListFilter = userCardListFilterMapper.selectOne(queryWrapper, false);
        if (null == entityListFilter) {
            userCardListFilter.setCreateTime(new Date());
            userCardListFilterMapper.insert(userCardListFilter);
        } else {
            userCardListFilter.setUpdateTime(new Date());
            userCardListFilterMapper.update(userCardListFilter, queryWrapper);
        }
    }


    @Override
    public UserCardListFilter getUserCardListFilter(UserCardListFilterQueryDTO queryDTO) {
        LambdaQueryWrapper<UserCardListFilter> queryWrapper = handleQueryWrapper(queryDTO.getUserId(), queryDTO.getComponentId(), queryDTO.getPageId(), queryDTO.getTenantId()
                , queryDTO.getTmActivityId(), queryDTO.getDataId());
        return userCardListFilterMapper.selectOne(queryWrapper, false);
    }

    @Override
    public UserCardListFilter getUserCardListFilterByTmActivityIdAndUserId(UserCardListFilterQueryDTO queryDTO) {
        LambdaQueryWrapper<UserCardListFilter> queryWrapper = handleQueryWrapper(queryDTO.getUserId(), queryDTO.getTenantId(), queryDTO.getTmActivityId());
        return userCardListFilterMapper.selectOne(queryWrapper, false);
    }

    private LambdaQueryWrapper<UserCardListFilter> handleQueryWrapper(String userId, String componentId, String pageId, String tenantId, String tmActivityId, String dataId) {
        LambdaQueryWrapper<UserCardListFilter> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserCardListFilter::getUserId, userId);
        queryWrapper.eq(UserCardListFilter::getComponentId, componentId);
        queryWrapper.eq(UserCardListFilter::getPageId, pageId);
        queryWrapper.eq(UserCardListFilter::getTenantId, tenantId);
        queryWrapper.eq(UserCardListFilter::getTmActivityId, tmActivityId);
        queryWrapper.eq(UserCardListFilter::getDataId, dataId);
        return queryWrapper;
    }

    private LambdaQueryWrapper<UserCardListFilter> handleQueryWrapper(String userId, String tenantId, String tmActivityId) {
        LambdaQueryWrapper<UserCardListFilter> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserCardListFilter::getUserId, userId);
        queryWrapper.eq(UserCardListFilter::getTenantId, tenantId);
        queryWrapper.eq(UserCardListFilter::getTmActivityId, tmActivityId);
        return queryWrapper;
    }
}