package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.mapper.db1.UserDashBoardSettingMapper;
import com.digiwin.mobile.mobileuibot.model.db1.UserDashBoardSetting;
import com.digiwin.mobile.mobileuibot.mysql.service.UserDashBoardSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author xujinc
 * @date 2024/12/11
 */
@Service
public class UserDashBoardSettingServiceImpl extends ServiceImpl<UserDashBoardSettingMapper, UserDashBoardSetting> implements UserDashBoardSettingService {
    @Autowired
    private UserDashBoardSettingMapper userDashBoardSettingMapper;

    @Override
    public boolean insertOrUpdateUserDashBoardSetting(UserDashBoardSetting userDashBoardSetting) {
        LambdaQueryWrapper<UserDashBoardSetting> queryWrapper = handleQueryWrapper(userDashBoardSetting);
        UserDashBoardSetting userDashBoardSettingDtd = userDashBoardSettingMapper.selectOne(queryWrapper, false);
        if (Objects.isNull(userDashBoardSettingDtd)) {
            return userDashBoardSettingMapper.insert(userDashBoardSetting) > 0;
        } else {
            return userDashBoardSettingMapper.update(userDashBoardSetting, queryWrapper) > 0;
        }
    }

    @Override
    public UserDashBoardSetting getUserDashBoardSetting(UserDashBoardSetting userDashBoardSetting) {
        LambdaQueryWrapper<UserDashBoardSetting> queryWrapper = handleQueryWrapper(userDashBoardSetting);
        return userDashBoardSettingMapper.selectOne(queryWrapper, false);
    }

    private LambdaQueryWrapper<UserDashBoardSetting> handleQueryWrapper(UserDashBoardSetting userDashBoardSetting) {
        LambdaQueryWrapper<UserDashBoardSetting> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserDashBoardSetting::getUserId, userDashBoardSetting.getUserId());
        queryWrapper.eq(UserDashBoardSetting::getTenantId, userDashBoardSetting.getTenantId());
        queryWrapper.eq(UserDashBoardSetting::getCode, userDashBoardSetting.getCode());
        return queryWrapper;
    }

}