package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.mapper.db1.UserProjectFilterMapper;
import com.digiwin.mobile.mobileuibot.model.db1.UserProjectFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserProjectFilterService;
import lombok.Synchronized;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * <p>功能描述：用户项目配置设置表 实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserProjectFilterServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/7/24 13:17
 */
@Service
public class UserProjectFilterServiceImpl implements UserProjectFilterService {

    @Autowired
    private UserProjectFilterMapper userProjectFilterMapper;

    @Override
    public UserProjectFilter selectByParams(String userId, String tenantId, String pageFilterCode) {
        LambdaQueryWrapper<UserProjectFilter> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(UserProjectFilter::getUserId, userId);
        wrapper.eq(UserProjectFilter::getTenantId, tenantId);
        wrapper.eq(UserProjectFilter::getFilterCode, pageFilterCode);
        return userProjectFilterMapper.selectOne(wrapper, false);
    }

    @Override
    @Synchronized
    public void modifyByQueryParam(String userId, String tenantId, String pageFilterCode, String queryParam) {
        queryParam = queryParam == null ? "" : queryParam;
        UserProjectFilter userProjectFilter = this.selectByParams(userId, tenantId, pageFilterCode);
        if (userProjectFilter != null) {
            userProjectFilter.setTime(new Date());
            userProjectFilter.setQueryParam(queryParam);
            userProjectFilterMapper.updateById(userProjectFilter);
            return;
        }
        userProjectFilterMapper.insert(
                new UserProjectFilter()
                        .setUserId(userId).setTenantId(tenantId).setFilterCode(pageFilterCode)
                        .setTime(new Date())
                        .setQueryParam(queryParam));
    }

    @Override
    @Synchronized
    public void modifyByGroupFilter(String userId, String tenantId, String pageFilterCode, String groupFilter) {
        UserProjectFilter userProjectFilter = selectByParams(userId, tenantId, pageFilterCode);
        if (userProjectFilter != null) {
            userProjectFilter.setTime(new Date());
            userProjectFilter.setGroupFilter(groupFilter);
            userProjectFilterMapper.updateById(userProjectFilter);
            return;
        }
        userProjectFilterMapper.insert(
                new UserProjectFilter()
                        .setUserId(userId).setTenantId(tenantId).setFilterCode(pageFilterCode)
                        .setTime(new Date())
                        .setGroupFilter(groupFilter));
    }

}
