package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.mapper.db1.UserTaskFilterMapper;
import com.digiwin.mobile.mobileuibot.model.db1.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import lombok.Synchronized;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author wuyangz
 * @date 202303310
 */
@Service
public class UserTaskFilterServiceImpl implements UserTaskFilterService {

    @Autowired
    private UserTaskFilterMapper taskFilterMapper;

    @Override
    @Synchronized
    public Boolean insertUserTaskFilter(UserTaskFilter userTaskFilter, String queryParam, String filterIds) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            userTaskFilter.setId(oldUserTaskFilter.getId());
            userTaskFilter.setCommonFilter(oldUserTaskFilter.getCommonFilter());
            userTaskFilter.setSeniorFilter(oldUserTaskFilter.getSeniorFilter());
            userTaskFilter.setIsUseSeniorFilter(oldUserTaskFilter.getIsUseSeniorFilter());
            userTaskFilter.setGroupFilterIds(oldUserTaskFilter.getGroupFilterIds());
            userTaskFilter.setSortFilter(oldUserTaskFilter.getSortFilter());
            if (StringUtil.isEmpty(queryParam)) {
                userTaskFilter.setQueryParam(oldUserTaskFilter.getQueryParam());
            } else {
                userTaskFilter.setQueryParam(queryParam);
            }
            if (StringUtil.isEmpty(filterIds)) {
                userTaskFilter.setFilterIds(oldUserTaskFilter.getFilterIds());
            } else {
                userTaskFilter.setFilterIds(filterIds);
            }
            return taskFilterMapper.updateById(userTaskFilter) > 0;
        }
        userTaskFilter.setQueryParam(queryParam);
        userTaskFilter.setFilterIds(filterIds);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterByQueryParam(UserTaskFilter userTaskFilter, String queryParam) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            userTaskFilter.setId(oldUserTaskFilter.getId());
            userTaskFilter.setFilterIds(oldUserTaskFilter.getFilterIds());
            userTaskFilter.setCommonFilter(oldUserTaskFilter.getCommonFilter());
            userTaskFilter.setSeniorFilter(oldUserTaskFilter.getSeniorFilter());
            userTaskFilter.setIsUseSeniorFilter(oldUserTaskFilter.getIsUseSeniorFilter());
            userTaskFilter.setGroupFilterIds(oldUserTaskFilter.getGroupFilterIds());
            userTaskFilter.setSortFilter(oldUserTaskFilter.getSortFilter());
            if (StringUtil.isEmpty(queryParam)) {
                userTaskFilter.setQueryParam("");
            } else {
                userTaskFilter.setQueryParam(queryParam);
            }
            return taskFilterMapper.updateById(userTaskFilter) > 0;
        }
        userTaskFilter.setQueryParam(queryParam);
        userTaskFilter.setFilterIds("");
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterByFilterIds(UserTaskFilter userTaskFilter, String filterIds) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            userTaskFilter.setId(oldUserTaskFilter.getId());
            userTaskFilter.setQueryParam(oldUserTaskFilter.getQueryParam());
            userTaskFilter.setCommonFilter(oldUserTaskFilter.getCommonFilter());
            userTaskFilter.setSeniorFilter(oldUserTaskFilter.getSeniorFilter());
            userTaskFilter.setIsUseSeniorFilter(oldUserTaskFilter.getIsUseSeniorFilter());
            userTaskFilter.setGroupFilterIds(oldUserTaskFilter.getGroupFilterIds());
            userTaskFilter.setSortFilter(oldUserTaskFilter.getSortFilter());
            if (StringUtil.isEmpty(filterIds)) {
                userTaskFilter.setFilterIds("");
            } else {
                userTaskFilter.setFilterIds(filterIds);
            }
            return taskFilterMapper.updateById(userTaskFilter) > 0;
        }
        userTaskFilter.setQueryParam("");
        userTaskFilter.setFilterIds(filterIds);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterByGroupFilterIds(UserTaskFilter userTaskFilter, String groupFilterIds) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            oldUserTaskFilter.setGroupFilterIds(groupFilterIds);
            return taskFilterMapper.updateById(oldUserTaskFilter) > 0;
        }
        userTaskFilter.setGroupFilterIds(groupFilterIds);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterBySortFilterIds(UserTaskFilter userTaskFilter, String sortFilter) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            oldUserTaskFilter.setSortFilter(sortFilter);
            return taskFilterMapper.updateById(oldUserTaskFilter) > 0;
        }
        userTaskFilter.setSortFilter(sortFilter);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterByCommonFilter(UserTaskFilter userTaskFilter, String commonFilter) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            oldUserTaskFilter.setIsUseSeniorFilter(false);
            oldUserTaskFilter.setCommonFilter(commonFilter);
            oldUserTaskFilter.setSeniorFilter(StringUtils.EMPTY);
            return taskFilterMapper.updateById(oldUserTaskFilter) > 0;
        }
        userTaskFilter.setIsUseSeniorFilter(false);
        userTaskFilter.setCommonFilter(commonFilter);
        userTaskFilter.setSeniorFilter(StringUtils.EMPTY);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    @Synchronized
    public Boolean insertUserTaskFilterBySeniorFilter(UserTaskFilter userTaskFilter, String seniorFilter) {
        UserTaskFilter oldUserTaskFilter = getUserTaskFilterByParams(userTaskFilter);
        userTaskFilter.setTime(new Date());
        if (oldUserTaskFilter != null) {
            oldUserTaskFilter.setIsUseSeniorFilter(true);
            oldUserTaskFilter.setCommonFilter(StringUtils.EMPTY);
            oldUserTaskFilter.setSeniorFilter(seniorFilter);
            return taskFilterMapper.updateById(oldUserTaskFilter) > 0;
        }
        userTaskFilter.setIsUseSeniorFilter(true);
        userTaskFilter.setCommonFilter(StringUtils.EMPTY);
        userTaskFilter.setSeniorFilter(seniorFilter);
        return taskFilterMapper.insert(userTaskFilter) > 0;
    }

    @Override
    public UserTaskFilter getUserTaskFilterByParams(UserTaskFilter userTaskFilter) {
        return taskFilterMapper.selectOne(new LambdaQueryWrapper<>(userTaskFilter), false);
    }
}
