package com.digiwin.mobile.mobileuibot.myteam;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitle;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 团队任务卡列表页
 *
 * @author 吴阳
 * @date 20230103
 */
@Component("uiBotModelBuildTeamTaskStrategy")
public class UiBotModelBuildTeamTaskStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildTeamTaskStrategy.class);

    /**
     * teamMember-团队成员
     */
    private static final String GROUP_TYPE_TEAM_MEMBER = "teamMember";
    /**
     * code-任务类型/团队类型
     */
    private static final String GROUP_TYPE_CODE = "code";

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String userId = apiRequest.getUserId();
        ApiRawData rawData = apiRequest.getRawData();
        String groupType = (String) rawData.get("groupType");
        Map<String, Object> params = new HashMap<>(3);
        params.put("groupType", groupType);
        if (GROUP_TYPE_TEAM_MEMBER.equalsIgnoreCase(groupType)) {
            params.put("userId", rawData.get("userId"));
        } else if (GROUP_TYPE_CODE.equalsIgnoreCase(groupType)) {
            params.put("taskDefCode", rawData.get("taskDefCode"));
        }
        String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List<DigiwinAtmcBacklog> teamBacklogs = digiwinAtmcProxyService.getDepartBacklogGroupList(
                iamUserToken, tenantId, locale, params);
        List<TaskSummary> taskSummaries = TaskSummary.createByBacklogs(teamBacklogs,
                taskFilterService, customTaskConfigService, pageTaskRelationService,
                locale, iamUserToken, userId, localeService, tenantId, activityFilterService, tenantVersion);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case TeamTitle.COMPONENT_TYPE:
                    pageData.put(schema, JsonUtil.objectToJavaObject(rawData.get(schema), TeamTitle.class));
                    break;
                case TodoList.COMPONENT_TYPE:
                    TodoList todoList = new TodoList();
                    todoList.setTodoList(TaskSummary.sortTeamList(taskSummaries));
                    todoList.setIsTeamTask(true);
                    pageData.put(schema, todoList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
