package com.digiwin.mobile.mobileuibot.navigation;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.gptai.GptAiModel;
import com.digiwin.mobile.mobileuibot.gptai.GptAiService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 底导航
 *
 * @author zhangjj
 * @date 2021/9/10 0010 16:27
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/navigation")
public class NavigationController {
    private static int GPT_AI_HAVE_PERMISSION = 1;

    @Autowired
    private NavigationService navigationService;

    @Autowired
    private UiBotService uiBotService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private GptAiService gptAiService;

    @Autowired
    private AiAssistantService aiAssistantService;

    @RequestMapping(value = "/nonSuperAdminNotSetAccount",method = RequestMethod.POST)
    public ApiResponse<String> nonSuperAdminNotSetAccount(@RequestBody ApiRequest apiRequest){
        boolean b = uiBotService.nonSuperAdminNotSetAccount(apiRequest);
        if (b){
            if (apiRequest.getLocale().equals("zh_CN")) {
                return ApiResponse.buildOK("【用户与员工未关联】或【员工未设定所属部门】，请联系超级管理员前往云控制台完成设定。");
            }else{
                return ApiResponse.buildOK("【用戶與員工未關聯】或【員工未設定所屬部門】，請聯繫超級管理員前往雲控制台完成設定。");
            }
        }else{
            return ApiResponse.buildOK(null);
        }
    }

    @RequestMapping(value = "/bottom", method = RequestMethod.POST)
    public ApiResponse<List<BottomNavigation>> getBottomNavigation(@RequestBody ApiRequest apiRequest)
            throws IOException {
        //敏捷问数私有化
        if (BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            String bottomNavigationString = FileUtil.readText("./static/agiledata/agileData-privatization-bottom.json");
            List<BottomNavigation> bottomNavigationList = JsonUtil.jsonStringToObject(bottomNavigationString, new TypeReference<List<BottomNavigation>>() {
            });
            return ApiResponse.buildOK().setData(bottomNavigationList);
        }

        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            return this.doMockData();
        }
        if (Objects.nonNull(apiRequest.getVersionDefault())) {
            /*String locale = apiRequest.getLocale();
            if (!TestController.specialHandleSwitch()) {
                // 员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控 底部按钮 返回 空数组
                if (uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
                    return ApiResponse.buildOK().setData(Collections.emptyList());
                }
            }*/

            Navigation navigation;
        /*if (!TestController.specialHandleSwitch()) {
            navigation = navigationService.findFirst();
        } else {
            navigation = JsonUtil.jsonStringToObject(getBottomNavigationMockDatanew(), Navigation.class);
        }*/
            navigation = JsonUtil.jsonStringToObject(getBottomNavigationMockDatanew(), Navigation.class);
            if (navigation != null) {
                List<BottomNavigation> bottomNavigationList = navigation.getBottomNavigations();
                if (bottomNavigationList != null) {
                    List<GptAiModel> list = new ArrayList<>();
                    for (BottomNavigation bottomNavigation : bottomNavigationList) {
                        handleNanaAuthorizations(apiRequest, bottomNavigation, list);
                    /*bottomNavigation.setPageTitle(LocaleUtil.getMobileTextByKey(locale,
                            bottomNavigation.getPageId()));
                    bottomNavigation.setName(LocaleUtil.getMobileTextByKey(locale,
                            bottomNavigation.getPageId()));*/
                    }
                    //1，所有助理若无均授权，娜娜IP即不出现,只有有助理权限情况下，娜娜才会出现
                    if (CollectionUtils.isEmpty(list)) {
                        bottomNavigationList.removeIf(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId()));
                    }
                }
                return ApiResponse.buildOK().setData(navigation.getBottomNavigations());
            }
        }else{
            String locale = apiRequest.getLocale();
            if (!TestController.specialHandleSwitch()) {
                // 员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控 底部按钮 返回 空数组
                if (uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
                    return ApiResponse.buildOK().setData(Collections.emptyList());
                }
            }

            Navigation navigation;
        if (!TestController.specialHandleSwitch()) {
            navigation = navigationService.findFirst();
        } else {
            navigation = JsonUtil.jsonStringToObject(getBottomNavigationMockData(), Navigation.class);
        }
            if (navigation != null) {
                List<BottomNavigation> bottomNavigationList = navigation.getBottomNavigations();
                if (bottomNavigationList != null) {
                    List<GptAiModel> list = new ArrayList<>();
                    for (BottomNavigation bottomNavigation : bottomNavigationList) {
                        handleNanaAuthorizations(apiRequest, bottomNavigation, list);
                    bottomNavigation.setPageTitle(LocaleUtil.getMobileTextByKey(locale,
                            bottomNavigation.getPageId()));
                    bottomNavigation.setName(LocaleUtil.getMobileTextByKey(locale,
                            bottomNavigation.getPageId()));
                    }
                    //1，所有助理若无均授权，娜娜IP即不出现,只有有助理权限情况下，娜娜才会出现
                    if (CollectionUtils.isEmpty(list)) {
                        bottomNavigationList.removeIf(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId()));
                    }
                }
                return ApiResponse.buildOK().setData(navigation.getBottomNavigations());
            }
        }
        return ApiResponse.buildError();
    }

    /**
     * 给默认门户使用
     * @return
     */
    private String getBottomNavigationMockDatanew(){
        return "{\n" +
                "\t\"_id\": \"613b08f3530e71620cc5e111\",\n" +
                "\t\"bottomNavigations\": [\n" +
                "\t\t{\n" +
                "\t\t\t\"name\": null,\n" +
                "\t\t\t\"selectedIcon\": \"assets/svg/ic_msg_selected.svg\",\n" +
                "\t\t\t\"unSelectedIcon\": \"assets/svg/ic_msg_unselected.svg\",\n" +
                "\t\t\t\"pageId\": \"NOTIFICATION_PAGE\",\n" +
                "\t\t\t\"pageTitle\": \"消息\"\n" +
                "\t\t},\n" +
                "\t\t{\n" +
                "\t\t\t\"name\": null,\n" +
                "\t\t\t\"selectedIcon\": \"assets/svg/ic_home_selected.svg\",\n" +
                "\t\t\t\"unSelectedIcon\": \"assets/svg/ic_home_unselected.svg\",\n" +
                "\t\t\t\"pageId\": \"INDEX_PORTAL\",\n" +
                "\t\t\t\"pageTitle\": \"首页\"\n" +
                "\t\t},\n" +
                "\t\t{\n" +
                "\t\t\t\"name\": null,\n" +
                "\t\t\t\"selectedIcon\": null,\n" +
                "\t\t\t\"unSelectedIcon\": null,\n" +
                "\t\t\t\"pageId\": \"GPT_AI\",\n" +
                "\t\t\t\"pageTitle\": \"娜娜\"\n" +
                "\t\t},\n" +
                "\t\t{\n" +
                "\t\t\t\"name\": null,\n" +
                "\t\t\t\"selectedIcon\": \"assets/svg/ic_discover_selected.svg\",\n" +
                "\t\t\t\"unSelectedIcon\": \"assets/svg/ic_discover_unselected.svg\",\n" +
                "\t\t\t\"pageId\": \"MOBILE_ATHENA_FOUND_PAGE\",\n" +
                "\t\t\t\"pageTitle\": \"发现\"\n" +
                "\t\t},\n" +
                "\t\t{\n" +
                "\t\t\t\"name\": null,\n" +
                "\t\t\t\"selectedIcon\": \"assets/svg/ic_my_selected.svg\",\n" +
                "\t\t\t\"unSelectedIcon\": \"assets/svg/ic_my_unselected.svg\",\n" +
                "\t\t\t\"pageId\": \"ME\",\n" +
                "\t\t\t\"pageTitle\": \"我的\"\n" +
                "\t\t}\n" +
                "\t]\n" +
                "}";
    }

    private String getBottomNavigationMockData(){
        // TODO 取消iconData  加字段selectIcon unselectIcon  值是str的圖片链接
        return "{   \n" +
                "    \"_id\" : \"613b08f3530e71620cc5e111\", \n" +
                "    \"bottomNavigations\" : [\n" +
                "        {\n" +
                "            \"iconData\" : 59110, \n" +
                "            \"name\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n" +
                "            \"pageId\" : \"NOTIFICATION_PAGE\", \n" +
                "            \"pageTitle\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n" +
                "            \"showName\" : false\n" +
                "        }, \n" +
                "        {\n" +
                "            \"iconData\" : 59111, \n" +
                "            \"name\" : \"${i18n-dj-mobile-INDEX}\", \n" +
                "            \"pageId\" : \"INDEX\", \n" +
                "            \"pageTitle\" : \"${i18n-dj-mobile-INDEX}\", \n" +
                "            \"showName\" : false\n" +
                "        }, \n" +
                "        {\n" +
                "            \"iconData\" : 59111, \n" +
                "            \"name\" : \"${i18n-dj-mobile-GPT_AI}\", \n" +
                "            \"pageId\" : \"GPT_AI\", \n" +
                "            \"pageTitle\" : \"${i18n-dj-mobile-GPT_AI}\", \n" +
                "            \"showName\" : false\n" +
                "        }, \n" +
                "        {\n" +
                "            \"iconData\" : 58939, \n" +
                "            \"name\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n" +
                "            \"pageId\" : \"MOBILE_MY_TODO\", \n" +
                "            \"pageTitle\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n" +
                "            \"showName\" : false, \n" +
                "            \"calenderType\" : 2\n" +
                "        }, \n" +
                "        {\n" +
                "            \"iconData\" : 59112, \n" +
                "            \"name\" : \"${i18n-dj-mobile-DASHBOARD}\", \n" +
                "            \"pageId\" : \"DASHBOARD\", \n" +
                "            \"pageTitle\" : \"${i18n-dj-mobile-DASHBOARD}\", \n" +
                "            \"showName\" : false\n" +
                "        }\n" +
                "    ]\n" +
                "}\n";
    }

    /**
     * 处理是否具有助理条件
     *
     * @param apiRequest
     * @param bottomNavigation
     * @param list
     */
    private void handleNanaAuthorizations(ApiRequest apiRequest, BottomNavigation bottomNavigation, List<GptAiModel> list) {
        if (PageSettingIdPresetEnum.GPT_AI.name().equals(bottomNavigation.getPageId())) {
            // 调用ASA获取授权应用的信息
            try {
                int assistantCount = aiAssistantService.queryAssistantCount(apiRequest);
                if (assistantCount != 0) {
                    list.add(new GptAiModel());
                }
            }
            catch (Exception e) {
                log.error("query product buy status error:{}", e.getMessage(), e);
            }
        }
    }

    private ApiResponse<List<BottomNavigation>> doMockData() {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        List<BottomNavigation> apiData = null;
        data = FileUtil.readText("static/appstore-use/navigation-bottom.json");
        if (null != data && !data.isEmpty()) {
            apiData =
                    JsonUtil.jsonStringToObject(data, new TypeReference<List<BottomNavigation>>() {
                    });
        }

        return ApiResponse.buildOK().setData(apiData);
    }


}