package com.digiwin.mobile.mobileuibot.news.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.service.NewsService;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;


/**
 * @author qutong 公告列表
 */
@RestController
@RequestMapping("/news/info")
public class MobileNewsController {

    @Autowired
    private NewsService newsService;

    @Autowired
    private LocaleService localeService;


    /**
     * 分页查询用户公告列表
     *
     * @param apiRequsetNews
     * @return
     */
    @PostMapping("/queryMobileNewsListPage")
    public ApiResponse queryMobileNewsListPage(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData(newsService.queryMobileNewsListPage(apiRequsetNews));
    }

    /**
     * 查询用户端公告详情
     *
     * @param apiRequsetNews
     * @return
     */
    @PostMapping("/queryUserNewsDetail")
    public ApiResponse queryUserNewsDetail(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData(newsService.queryUserNewsDetail(apiRequsetNews));
    }


    /**
     * 校验公告的是否存在/是否有效
     */
    @PostMapping("/validateNews")
    public ApiResponse validateNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData(newsService.validateNews(apiRequsetNews));
    }

    /**
     * 查询公告类型列表
     *
     * @param apiRequsetNews
     * @return
     */
    @PostMapping("/queryNewsTypeList")
    public ApiResponse queryNewsTypeList(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData(newsService.queryNewsTypeList(apiRequsetNews));
    }

    /**
     * 读取公告，记录为已读公告
     *
     * @param apiRequsetNews
     * @return
     */
    @PostMapping("/readNews")
    public ApiResponse readNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty(apiRequsetNews.getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.readNews(apiRequsetNews));
    }


    /**
     * 公告点赞
     * 0：表示点赞成功，1：表示重复点赞，2：公告不存在或者无权限
     */
    @PostMapping("/likeNews")
    public ApiResponse likeNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty(apiRequsetNews.getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.likeNews(apiRequsetNews));
    }

    /**
     * 公告取消点赞
     * 0：表示取消点赞成功，1：表示没有点赞记录，2：公告不存在或者无权限
     */
    @PostMapping("/cancelLikeNews")
    public ApiResponse cancelLikeNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty(apiRequsetNews.getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.cancelLikeNews(apiRequsetNews));
    }


    /**
     * 公告收藏
     * 0：表示收藏成功，1：表示重复收藏，2：公告不存在或者无权限，3：收藏失败
     */
    @PostMapping("/favoriteNews")
    public ApiResponse favoriteNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty(apiRequsetNews.getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.favoriteNews(apiRequsetNews));
    }

    /**
     * 公告取消收藏
     * 0：表示取消收藏成功，1：表示没有收藏记录（失败），2：取消收藏失败
     */
    @PostMapping("/cancelFavoriteNews")
    public ApiResponse cancelFavoriteNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (CollectionUtils.isEmpty(apiRequsetNews.getIdList())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.cancelFavoriteNews(apiRequsetNews));
    }


    /**
     * 我的公告收藏列表
     */
    @PostMapping("/myFavoriteNewsList")
    public ApiResponse myFavoriteNewsList(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData(newsService.myFavoriteNewsList(apiRequsetNews));
    }


    /**
     * 校验公告类型是否存在
     *
     * @param apiRequsetNews 请求入参
     * @return 返回
     */
    @PostMapping("/validNewsType")
    public ApiResponse validNewsType(@RequestBody ApiRequsetNews apiRequsetNews, HttpServletRequest request) {
        if (ObjectUtils.isEmpty(apiRequsetNews.getNewsTypeId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetNews.getLocale(), "请传入正确的参数"));
        }
        return ApiResponse.buildOK().setData(newsService.validNewsType(apiRequsetNews, AthenaBasicHttpRequestHead.buildByRequest(request)));
    }

}
