package com.digiwin.mobile.mobileuibot.news.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


/**
 * 公告信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ApiRequsetNews extends ApiRequest {

    /**
     * 排序字段 1:综合排序 2:按发布时间排序 3：按阅读数排序 4：发布时间+点赞+收藏排序
     */
    private Integer sortType;

    /**
     * 排序规则 desc:倒序 asc:正序，sortType=2或3时必传
     */
    private String orderByRule;

    /**
     * 调用场景，不传表示前台页面查询详情，传1表示管理后台查询详情
     */
    private Integer scene;

    /**
     * 公告类型id
     */
    private Long newsTypeId;

    /**
     * 公告类型id集合（末位分类集合）
     */
    private List<Long> newsTypeIdList;

    /**
     * 公告id
     */
    private Long id;

    /**
     * 公告id集合
     */
    private List<Long> idList;


    /**
     * 发布时间-开始，格式：yyyy-MM-dd HH:mm:ss
     */
    private String effectiveTimeStart;

    /**
     * 发布时间-结束，格式：yyyy-MM-dd HH:mm:ss
     */
    private String effectiveTimeEnd;

    /**
     * 有无附件标识 true:有 false:无，不传表示没有该条件
     */
    private Boolean attachmentFlag;

    /**
     * 搜索关键字
     */
    private String keyword;
}
