package com.digiwin.mobile.mobileuibot.news.model;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author qutong 公告信息
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class MobileNewsAnnouncement {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 公告标题
     */
    private String newsTitle;

    /**
     * 公告摘要
     */
    private String summary;

    /**
     * 公告发布时间
     */
    private String newsEffectiveTime;

    /**
     * 是否置顶 0:否 1:是
     */
    private Integer toppedFlag;

    /**
     * 是否已读 true:已读 false:未读
     */
    private Boolean readFlag;

    /**
     * 封面图默认icon
     */
    private String defaultImageIcon;

    /**
     * 封面图文件信息
     */
    private CoverImageInfo coverImageInfo;

    /**
     * 已读人员数量
     */
    private Integer readCount;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效
     */
    private Integer newsStatus;

    /**
     * 公告截止时间
     */
    private String newsEndTime;

    /**
     * 公告类型id
     */
    private Long newsTypeId;

    /**
     * 公告类型名称
     */
    private String newsTypeName;

    /**
     * 公告正文
     */
    private String newsContent;

    /**
     * 是否修改 0:否 1:是
     */
    private Integer modifiedFlag;

    /**
     * 已读人员信息
     */
    private List<UserDTO> readList;

    /**
     * 附件列表
     */
    private List<FileInfo> fileList;

    /**
     * 创建者账号
     */
    private String createUserId;

    /**
     * 创建日期
     */
    private String createTime;

    /**
     * 更新日期
     */
    private String modifyTime;

    /**
     * 创建者名称
     */
    private String createUserName;

    /**
     * 更新者账号
     */
    private String modifyUserId;

    /**
     * 更新者名称
     */
    private String modifyUserName;


    /**
     * 发布人类型，1（无）， 2（发布人姓名） 3（发布人角色）
     */
    private Integer publishType;

    /**
     * 发布人id（当publishType不为1时有值）
     */
    private String publishId;


    /**
     * 发布人姓名
     */
    private String publishName;

    /**
     * 点赞数量
     */
    private Integer likeCount;

    /**
     * 是否点赞 true:点赞 false:未点赞
     */
    private Boolean likeFlag;


    /**
     * 点赞人员集合
     */
    private List<UserDTO> likeList;

    /**
     * 收藏数
     */
    private Integer favoriteCount;

    /**
     * 是否收藏 true:收藏 false:未收藏
     */
    private Boolean favoriteFlag;

}
