package com.digiwin.mobile.mobileuibot.news.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author qutong 公告类型
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class MobileNewsType {

    /**
     * 公告类型id
     */
    private Long id;

    /**
     * 公告类型名称
     */
    private String name;

    /**
     * 公告类型说明
     */
    private String description;

    /**
     * 默认类型 0:否 1:是
     */
    private Integer defaultFlag;
    /**
     * 公告类型子集
     */
    private List<MobileNewsType> childrenList;
}
