package com.digiwin.mobile.mobileuibot.news.model;

import lombok.Data;

/**
 * 我的公告收藏
 */
@Data
public class MyNewsAnnouncementFavorite {

    /**
     * 公告收藏id
     */
    private Long id;


    /**
     * 收藏时间
     */
    private String favoriteTime;

    /**
     * 公告状态编码（1000 代表存在，1001 代表不存在，1002 代表失效，未发布或者过期，1003 代表没有权限）
     */
    private String newsStatusCode;

    /**
     * 公告id
     */
    private Long newsId;

    /**
     * 公告标题
     */
    private String newsTitle;

    /**
     * 公告摘要
     */
    private String summary;


    /**
     * 公告生效时间
     */
    private String newsEffectiveTime;

    /**
     * 点赞数量
     */
    private Integer likeCount;

    /**
     * 已读人员数量
     */
    private Integer readCount;

    /**
     * 封面图默认icon
     */
    private String defaultImageIcon;

    /**
     * 封面图文件id
     */
    private String coverImageId;

    /**
     * 封面图文件信息
     */
    private CoverImageInfo coverImageInfo;
}
