package com.digiwin.mobile.mobileuibot.news.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsAnnouncement;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsType;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;

import java.util.List;

public interface NewsService {
    

    /**
     * 分页查询用户公告列表
     * @param apiRequsetNews
     * @return
     */
    MobileNewsAnnouncementPageResp queryMobileNewsListPage(ApiRequsetNews apiRequsetNews);


    /**
     * 查询用户端公告详情
     * @param apiRequsetNews
     * @return
     */
    MobileNewsAnnouncement queryUserNewsDetail(ApiRequsetNews apiRequsetNews);

    /**
     * 校验公告的是否存在/是否有效
     * @param apiRequsetNews
     * @return
     */
    JSONObject validateNews(ApiRequsetNews apiRequsetNews);

    /**
     * 查询公告类型列表
     * @param apiRequsetNews
     * @return
     */
    List<MobileNewsType> queryNewsTypeList(ApiRequsetNews apiRequsetNews);

    /**
     * 读取公告，记录为已读公告
     * @param apiRequsetNews
     * @return
     */
    Boolean readNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告点赞
     *
     * @return 0：表示点赞成功，1：表示重复点赞，2：公告不存在或者无权限
     */
    Integer likeNews(ApiRequsetNews apiRequsetNews);


    /**
     * 公告取消点赞
     *
     * @return 0：表示取消点赞成功，1：表示没有点赞记录，2：公告不存在或者无权限
     */
    Integer cancelLikeNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告收藏
     *
     * @return 0：表示收藏成功，1：表示重复收藏，2：公告不存在或者无权限，3：收藏失败
     */
    Integer favoriteNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告取消收藏
     *
     * @return 0：表示取消收藏成功，1：表示没有收藏记录（失败），2：取消收藏失败
     */
    Integer cancelFavoriteNews(ApiRequsetNews apiRequsetNews);

    /**
     * 我的公告收藏列表
     */
    MyNewsAnnouncementFavoritePageResp myFavoriteNewsList(ApiRequsetNews apiRequsetNews);


    /**
     * 校验公告类型是否存在
     *
     * @param apiRequsetNews 请求入参
     * @param athenaBasicHttpRequestHead 请求头
     * @return 返回
     */
    Boolean validNewsType(ApiRequsetNews apiRequsetNews, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead);
}
