package com.digiwin.mobile.mobileuibot.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsAnnouncement;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsType;
import com.digiwin.mobile.mobileuibot.news.service.NewsService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("newsService")
public class NewsServiceImpl implements NewsService {

    @Autowired
    private DigiwinSemcProxyService semcProxyService;


    @Override
    public MobileNewsAnnouncementPageResp queryMobileNewsListPage(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.queryMobileNewsListPage(apiRequsetNews);
    }

    @Override
    public MobileNewsAnnouncement queryUserNewsDetail(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.queryUserNewsDetail(apiRequsetNews);
    }

    @Override
    public JSONObject validateNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.validateNews(apiRequsetNews);
    }

    @Override
    public List<MobileNewsType> queryNewsTypeList(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.queryNewsTypeList(apiRequsetNews);
    }

    @Override
    public Boolean readNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.readNews(apiRequsetNews);
    }

    @Override
    public Integer likeNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.likeNews(apiRequsetNews);
    }

    @Override
    public Integer cancelLikeNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.cancelLikeNews(apiRequsetNews);
    }

    @Override
    public Integer favoriteNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.favoriteNews(apiRequsetNews);
    }

    @Override
    public Integer cancelFavoriteNews(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.cancelFavoriteNews(apiRequsetNews);
    }

    @Override
    public MyNewsAnnouncementFavoritePageResp myFavoriteNewsList(ApiRequsetNews apiRequsetNews) {
        return semcProxyService.myFavoriteNewsList(apiRequsetNews);
    }

    /**
     * 校验公告类型是否存在
     *
     * @param apiRequsetNews 请求入参
     * @param athenaBasicHttpRequestHead 请求头
     * @return 返回
     */
    @Override
    public Boolean validNewsType(ApiRequsetNews apiRequsetNews, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        return semcProxyService.validNewsType(apiRequsetNews, athenaBasicHttpRequestHead);
    }

}
