package com.digiwin.mobile.mobileuibot.notification;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationRemoveResp;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummary;
import com.digiwin.mobile.mobileuibot.notification.model.PushNotification;
import com.digiwin.mobile.mobileuibot.notification.service.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationController
 * @Author: Zaregoto
 * @Date: 2021/4/21 15:22
 */
@RestController
@RequestMapping("/mobile/v1/notification")
public class NotificationController {

    private static final String CREATE_NAME = "Athena";
    private static final Logger logger = LoggerFactory.getLogger(NotificationController.class);

    private final NotificationService notificationService;

    public NotificationController(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @RequestMapping(value = "/sort/list", method = RequestMethod.GET)
    public ApiResponse<List<NotificationSummary>> listNotificationSummary(
            @RequestParam(name = "clientId") String clientId,
            @RequestParam(name = "iamUserToken") String iamUserToken,
            @RequestParam(name = "locale") String locale, Integer pageNum) throws IOException {
        List<NotificationSummary> notificationSummaries =
                this.notificationService.listNotificationSummaries(clientId, iamUserToken, locale, pageNum, 10);
        if (notificationSummaries != null) {
            return ApiResponse.buildOK().setData(notificationSummaries);
        } else {
            return ApiResponse.buildError();
        }
    }

    @RequestMapping(value = "/send", method = RequestMethod.POST)
    @ResponseBody
    public String noticeSend(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        logger.error("准备发送通知...进入noticeSend方法...");
        String rawRequestData = RequestParameterUtil.getPostData(request, false, "UTF-8");
        logger.error("接收到的http body数据是.. .{}", rawRequestData);
        Map<String, Object> requestMap = JsonUtil.jsonStringToObject(rawRequestData, Map.class);

        // 准备响应数据
        JSONObject root = new JSONObject();
        JSONObject stdData = new JSONObject();
        JSONObject execution = new JSONObject();
        JSONObject parameter = new JSONObject();
        root.put("std_data", stdData);
        stdData.put("execution", execution);
        execution.put("code", "0");
        execution.put("description", "Request Success");
        execution.put("sql_code", "0");
        stdData.put("parameter", parameter);
        parameter.put("send_datetime", new Date());

        if (requestMap != null) {
            Map rootMap = (Map) requestMap.get("std_data");
            Map paramMap = (Map) rootMap.get("parameter");
            if (paramMap != null && !paramMap.isEmpty()) {
                String outerTenantId = (String) paramMap.get("outer_tenant_id");
                String outerTenantSid = (String) paramMap.get("outer_tenant_sid");
                String outerUserId = (String) paramMap.get("outer_user_id");
                String creatorName = (String) paramMap.get("creator_name");
                if (!StringUtils.hasLength(outerTenantId) && !StringUtils.hasLength(outerTenantSid)) {
                    execution.put("code", "-1");
                    execution.put("description", "请输入租户Id或者SID");
                    parameter.put("send_datetime", "");
                    return root.toString();
                }
                if (!StringUtils.hasLength(outerUserId)) {
                    execution.put("code", "-1");
                    execution.put("description", "请输入用户ID");
                    parameter.put("send_datetime", "");
                    return root.toString();
                }
                if (!StringUtils.hasLength(creatorName)) {
                    creatorName = CREATE_NAME;
                }
                //推送的内容
                String content = (String) paramMap.get("content");
                //推送跳转的链接
                String detailUrl = (String) paramMap.get("detail_url");
                Map detail = (Map) paramMap.get("detail");
                String locale = (String) paramMap.get("locale");
                //推送的标题
                String title = (String) paramMap.get("title");
                List label = (List) paramMap.get("label");
                logger.error("发送消息给：{}", outerUserId);
                PushNotification push = new PushNotification();
                push.setContent(content);
                push.setTitle(title);
                push.setDetail(detail);
                push.setTenantId(outerTenantId);
                push.setUrl(detailUrl);
                push.setApnsProduction(true);
                notificationService.pushNotificationToUserId(outerUserId, outerTenantId, push, creatorName, label);
            } else {
                logger.error("发送通知消息失败...请求参数内容不正确");
                execution.put("code", "-1");
                execution.put("description", "Parameter node invalid.");
                execution.put("sql_code", "0");
                stdData.put("parameter", parameter);
                parameter.put("send_datetime", "");
                return root.toString();
            }
        } else {
            logger.error("发送通知消息失败...没有请求参数");
            execution.put("code", "-1");
            execution.put("description", "No Request Parameter.");
            execution.put("sql_code", "0");
            stdData.put("parameter", parameter);
            parameter.put("send_datetime", "");
            return root.toString();
        }
        return root.toString();
    }

    /**
     *  一键清除工作提醒
     *  @return
     */
    @GetMapping(value = "/remove")
    public ApiResponse<NotificationRemoveResp> oneClickRemove() {
        return ApiResponse.buildOK(notificationService.oneClickRemove());
    }
}
