package com.digiwin.mobile.mobileuibot.notification;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTemplateEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationFieldListDisplay;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationGroupDisplay;
import com.digiwin.mobile.mobileuibot.notification.service.impl.NotificationExtContentTmpl;
import com.digiwin.mobile.mobileuibot.notification.service.impl.NotificationFieldListExtContentTmpl;
import com.digiwin.mobile.mobileuibot.notification.service.impl.NotificationGroupDisplayExtContentTmpl;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.List;

/**
 * <p>功能描述：消息变更的抽象实现类反序列化处理器</p>
 *
 * @author: 严峰
 * @Date: 2022/6/28
 */
@Slf4j
public class NotificationExtContentJsonDeserializer extends JsonDeserializer<NotificationExtContentTmpl> {

    @Override
    public NotificationExtContentTmpl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        log.debug("NotificationExtContentJsonDeserializer activated!!!");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        String templateType = node.get("templateType").toString();

        if (AthenaMessageTemplateEnum.GROUP_DISPLAY.getType().equalsIgnoreCase(templateType)) {
            List<NotificationGroupDisplay> GroupDisplayList = JsonUtil.jsonStringToObject(node.get("templateData").toString()
                    , new TypeReference<List<NotificationGroupDisplay>>() {
                    });
            return new NotificationGroupDisplayExtContentTmpl(templateType, GroupDisplayList);
        }
        if (AthenaMessageTemplateEnum.FIELD_LIST.getType().equalsIgnoreCase(templateType)) {
            List<NotificationFieldListDisplay> fieldListDisplayList = JsonUtil.jsonStringToObject(node.get("templateData").toString()
                    , new TypeReference<List<NotificationFieldListDisplay>>() {
                    });
            return new NotificationFieldListExtContentTmpl(templateType, fieldListDisplayList);
        }
        return null;
    }
}
