package com.digiwin.mobile.mobileuibot.notification.enums;

/**
 * <p>功能描述：移动端消息列表（基础功能组件）中，Athena场景的消息类别KEY</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AthenaMobileNotificationCategoryEnum
 * @Author: Zaregoto
 * @Date: 2021/4/21 10:44
 */
public enum AthenaMobileNotificationCategoryEnum {
    /**
     * 我的待办
     */
    @Deprecated
    MOBILE_MY_TODO,
    /**
     * 我的项目
     */
    @Deprecated
    MOBILE_MY_PROJECT,
    /**
     * 项目助理
     */
    @Deprecated
    MOBILE_PROJECT_ASSISTANT,
    /**
     * Athena助手
     * wuyang 20220318 改名为：工作提醒，与web端一致。其他通知分类也不再使用
     */
    MOBILE_ATHENA_ASSISTANT,
    /**
     * 内部个人消息
     */
    @Deprecated
    MOBILE_INTERNAL_PERSONAL,
    /**
     * 系统消息
     */
    @Deprecated
    MOBILE_SYSTEM;


    private Integer order;

    AthenaMobileNotificationCategoryEnum() {

    }


    public static AthenaMobileNotificationCategoryEnum getEnumByName(String name) {
        String tester = name;
//        if (name.toUpperCase().startsWith(MOBILE_INTERNAL_PERSONAL.toString())) {
//            tester = name.substring(MOBILE_INTERNAL_PERSONAL.toString().length());
//        }
        for (AthenaMobileNotificationCategoryEnum mobileNotificationCategoryEnum :
                AthenaMobileNotificationCategoryEnum.values()) {
            if (mobileNotificationCategoryEnum.name().equalsIgnoreCase(tester)) {
                return mobileNotificationCategoryEnum;
            }
        }
        return null;
    }
}
