package com.digiwin.mobile.mobileuibot.notification.model;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.AppBasePageNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.cardnormal.Card;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContent;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContentConfig;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContentMessageFiled;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * <p>功能描述：通知详情的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetail
 * @Author: Zaregoto
 * @Date: 2021/4/23 17:15
 */
@JSONType(deserializer = NotificationDetailFastJsonDeserializer.class)
public class NotificationDetail implements Serializable {
    private static final long serialVersionUID = 3614391637211741987L;
    private static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

    private NotificationPerson person;
    private Card card;
    private String content;
    private String jumpPageId;
    private NotificationLabel label;
    private String publishTime;
    private String title;
    private String dataId;
    private Boolean showPhoto;
    /**
     * 是否显示查看更多
     */
    private Boolean showSeeMore;

    /**
     * 不显示查看更多 并且是任务类型的消息
     * 提示语：移动端不支持该任务处理，请前往web端处理
     */
    private String noShowSeeMoreMsg;
    /**
     * 消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;
    /**
     * DigiwinAimMessage的消息ID
     */
    private String gid;

    /*应用其中type字段，1：打开新页面；2、底部弹窗打开新页面；3：调用接口，成功后返回上一页并刷新；31：调用接口，
    成功后跳转提交成功页面(此时返回不会返回到提交按钮页面)；4：返回上一页；41：接收回调，在点击时返回上一页，同时将接收的回调传给前一页面；
    5：Toast提示；6：右侧弹窗选择明细后跳转页面，此时requestUrl为获取明细接口；71：调用蓝牙打印组件；72：调用扫码组件（连续扫描）；
    81：顺时针旋转内容90度并全屏展示；82：逆时针旋转内容90度并全屏展示;9:用webview打开网页
     */
    //应用requestUrl表示跳转地址
    private Action action;

    /**
     * 返回task或者activity、EOC。task表示项目，activity表示任务，EOC表示提示消息
     *
     * @see AthenaMessageTypeEnum
     */
    private String msgType = "";
    /**
     * EOC类型下消息内容
     */
    private Map<String, Object> msgContent;

    /**
     * 是否使用消息模板
     */
    private Boolean isTemplateMessage;

    /**
     * 消息模板
     */
    private DigiwinAimMessageExtendContent extendDisplayContent;


    public NotificationDetail() {
    }

    /**
     * 创建APP消息页-工作提醒列表页中的一个消息对象
     * 该方法内逻辑要和以下方法保持一致：
     * com.digiwin.mobile.mobileuibot.notification.model.NotificationSummarySubject#create(java.lang.String, com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage, com.digiwin.mobile.mobileuibot.locale.service.LocaleService)
     *
     * @param locale                       语言别
     * @param digiwinAimMessage            工作提醒中的一个消息对象
     * @param card
     * @param mobileNotificationCategoryId
     * @param digiwinAtmcBacklogDetail     工作提醒中一个消息对象对应的任务卡详情（可能有，前提是消息是任务卡的消息）
     * @param customTaskConfigList         定制——任务卡跳转h5配置（使用设计器开发之前的旧方式，在mongodb中配置）
     * @param iamUserToken                 登录鼎捷云后的token
     * @return
     */
    public static NotificationDetail create(String locale, DigiwinAimMessage digiwinAimMessage, NotificationDetailPersonalCard card, String mobileNotificationCategoryId,
                                            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<CustomTaskConfig> customTaskConfigList, String iamUserToken) {
        NotificationDetail result = new NotificationDetail();
        result.setMsgType(Optional.ofNullable(digiwinAimMessage.getType()).orElse(""));
        result.setPerson(NotificationPerson.create(locale, digiwinAimMessage,
                AthenaMobileNotificationCategoryEnum.getEnumByName(mobileNotificationCategoryId)));
        result.setCard(card);
        //先声明action，后面要做判断和赋值复用
        Action action = new Action();
        // TODO 跳转页面还需要处理

        if (card != null && card.getAction() != null) {
//            Action action = card.getAction();
            action = card.getAction();
            result.setJumpPageId(action.getJumpPageId());
            result.setShowSeeMore(card.getShowSeeMore());
        }
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());
        result.setLabel(NotificationLabel.create(locale, digiwinAimMessage));
//        if (digiwinAimMessage.getContent() != null && digiwinAimMessage.getContent().getStartTime() != null && digiwinAimMessage.getContent().getStartTime().contains("T")) {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        } else {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        }
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        if (AthenaMessageTypeEnum.BASE_DATA_ENTRY.getType().equals(digiwinAimMessage.getType())) {
            // 数据录入
            if (digiwinAimMessage.getContent() != null) {
                //异常数量
                Integer failedNum = digiwinAimMessage.getContent().getFailedNum();
                //成功数量
                Integer succeededNumN = digiwinAimMessage.getContent().getSucceededNum();
                //进行中数量
                Integer processingNum = digiwinAimMessage.getContent().getProcessingNum();
                if (AthenaNotificationTypeEnum.EXCEPTION.toString().equals(digiwinAimMessage.getCategory())) {
                    result.setContent(localeService.getLanguageValue(locale, "导入异常，总数") + (failedNum + succeededNumN + processingNum) + localeService.getLanguageValue(locale, "笔") + "," + localeService.getLanguageValue(locale, "异常") + failedNum + localeService.getLanguageValue(locale, "笔") + "。");
                } else if (AthenaNotificationTypeEnum.OTHER.toString().equals(digiwinAimMessage.getCategory())) {
                    result.setContent(localeService.getLanguageValue(locale, "导入成功，总数") + (failedNum + succeededNumN + processingNum) + localeService.getLanguageValue(locale, "笔") + "。");
                }
                if (digiwinAimMessage.getContent().getActivityName() != null) {
                    if ("en_US".equals(locale)) {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getEnUSName());
                    } else if ("zh_TW".equals(locale)) {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getZhTWName());
                    } else {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getDefaultName());
                    }
                }
            }
        } else if (AthenaMessageTypeEnum.REMINDER.getType().equals(digiwinAimMessage.getType())) {
            // 提醒
            if (digiwinAimMessage.getContent() != null) {
                DigiwinAimMessageContent content = digiwinAimMessage.getContent();
                result.setTitle("【" + localeService.getLanguageValue(locale, "任务催办") + "】");
                result.setContent(localeService.getLanguageValue(locale, "您的任务") + content.getTaskName()
                        + localeService.getLanguageValue(locale, "即将逾期") + "，"
                        + localeService.getLanguageValue(locale, "所属项目") + content.getProjectName()
                        + "，" + localeService.getLanguageValue(locale, "项目发起人") + content.getPersonInChargeName());
            }
        } else if (AthenaMessageTypeEnum.TASK.getType().equals(digiwinAimMessage.getType())) {
            result.setShowSeeMore(false);
            result.setTitle(digiwinAimMessage.getContent().getTitle());
            result.setContent(digiwinAimMessage.getContent().getMsg());
            if (ObjectUtils.isEmpty(digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }
        } else {
            //新增/合并任务消息优化
            DigiwinAimMessageContentMessageFiled messageFiled = digiwinAimMessage.getContent().getMessageFiled();
            if (!ObjectUtils.isEmpty(digiwinAimMessage.getContent().getMessageFiled())) {
                handleCardSpliceContent(locale, digiwinAimMessage, messageFiled, result);
            } else {
                result.setContent(digiwinAimMessage.getContent().getMsg());
            }
            result.setTitle(digiwinAimMessage.getContent().getTitle());
        }
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setShowPhoto(false);

        if (StringUtils.hasLength(result.getJumpPageId())) {
            if (BooleanUtil.isFalse(result.getShowSeeMore())) {
                //消息有绑定任务ID/项目ID，但移动端并未支持该任务则消息内容底部提示「移动端不支持该任务处理，请前往web端处理>>」
                if (AthenaMessageTypeEnum.ACTIVITY.getType().equals(digiwinAimMessage.getType())) {
                    result.setNoShowSeeMoreMsg(localeService.getLanguageValue(locale, "此作业未配置移动端界面，暂不支持查看\n请前往Web端查阅处理"));
                }
            } else {
                result.setShowSeeMore(true);
            }
        } else {
            result.setShowSeeMore(false);
        }
        //模板消息
        if (ObjectUtil.isNotEmpty(digiwinAimMessage.getContent().getExtendDisplayContent())
                && ObjectUtil.isNotEmpty(digiwinAimMessage.getContent().getExtendDisplayContent().getMobile())) {
            result.setExtendDisplayContent(digiwinAimMessage.getContent().getExtendDisplayContent());
            result.setTemplateMessage(true);
        } else {
            result.setTemplateMessage(false);
        }

        //2022.04.13，Liux。增加action返回对象参数，是为了消息支持跳H5功能。
        for (CustomTaskConfig customTaskConfig : customTaskConfigList) {

            String tmTaskId = customTaskConfig.getTmTaskId();
            String tmActivityId = customTaskConfig.getTmActivityId();

            if (digiwinAtmcBacklogDetail != null && digiwinAtmcBacklogDetail.getId() != null &&
                    digiwinAtmcBacklogDetail.isEqualWithBacklogDetailInTaskIdAndActivityId(tmTaskId, tmActivityId)) {
                DigiwinAtmcBacklog digiwinAtmcBacklog = new DigiwinAtmcBacklog(
                        Long.valueOf(digiwinAtmcBacklogDetail.getBacklogId()),
                        digiwinAtmcBacklogDetail.getTmTaskId(), digiwinAtmcBacklogDetail.getTmActivityId(),
                        digiwinAtmcBacklogDetail.getTmCategory(), digiwinAtmcBacklogDetail.getTmPattern(),
                        digiwinAtmcBacklogDetail.getTenantId());
                String requestUrl = customTaskConfig.getCustomTaskUrl(locale, iamUserToken, digiwinAtmcBacklog);
                action.setType(DigiwinAtmcBacklogTypeEnum.ANSWER_TYPE_NINE.getValue());
                action.setRequestUrl(requestUrl);
                result.setAction(action);
                result.setShowSeeMore(true);
                break;
            } else {
                action.setDataId(result.getDataId());
                action.setJumpPageId(result.getJumpPageId());
                action.setType(DigiwinAtmcBacklogTypeEnum.ANSWER_TYPE_ONE.getValue());
                result.setAction(action);
                continue;
            }
        }

        if (AthenaMessageTypeEnum.AGILE_DATA_DETAIL.getType().equals(digiwinAimMessage.getType())) {
            // 敏捷数据详情页
            result.setShowSeeMore(true);
            result.setContent(digiwinAimMessage.getContent().getTitle());
            if (ObjectUtils.isEmpty(digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }

            action.setDataId(digiwinAimMessage.getContent().getId());
            action.setJumpPageId(AppBasePageNameEnum.AGILE_DATA_DETAIL.getValue());
            action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
            result.setAction(action);
        } else if (AthenaMessageTypeEnum.TEXT.getType().equals(digiwinAimMessage.getType())) {
            if (ObjectUtils.isEmpty(digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }
            // 智能助理来源的消息
            if ("ASA".equals(digiwinAimMessage.getSource())) {
                // 娜娜中智能助理消息类型
                result.setShowSeeMore(true);
                result.setContent(digiwinAimMessage.getContent().getMsg());
                result.setTitle(digiwinAimMessage.getContent().getTitle());

                action.setJumpPageId(AppBasePageNameEnum.AI_ASSISTANT.getValue());
                action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
                Map<String, Object> rawData = new HashMap<>();
                Map<String, Object> aiAssistantParams = new HashMap<>();
                // 和B娜定义的技能类型同步，用于APP端跳转后，显示正确的技能类型。
                aiAssistantParams.put("skillType", AiAssistantSkillTypeEnum.ADMINISTRATIVE_ASSISTANT.getValue());
                rawData.put("aiAssistantParams", aiAssistantParams);
                action.setRawData(rawData);
                result.setAction(action);
            }
            // 敏捷数据-数据订阅详情页面
            if ("AGILE_DATA".equals(digiwinAimMessage.getSource())) {
                result.setShowSeeMore(true);
                result.setContent(digiwinAimMessage.getContent().getMsg());
                result.setTitle(digiwinAimMessage.getContent().getTitle());
                action.setRawData(digiwinAimMessage.getAction());
                action.setJumpPageId(AppBasePageNameEnum.AGILE_DATA_SUBSCRIPTION_DETAIL.getValue());
                action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
                result.setAction(action);
            }
        }
        // 智驱工作台公告
        if (Objects.equals(AthenaMessageTypeEnum.NEWS.getType(), digiwinAimMessage.getType()) && "semc".equals(digiwinAimMessage.getSource())) {
            result.setShowSeeMore(true);
            action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
            action.setJumpPageId(PortalConstans.MOBILE_NEWS_ROUTER);
            Map<String, Long> map = new HashMap<>();
            if (!ObjectUtils.isEmpty(digiwinAimMessage.getContent()) && StringUtil.isNotEmpty(digiwinAimMessage.getContent().getId())) {
                map.put("id", Long.parseLong(digiwinAimMessage.getContent().getId()));
            }
            action.setRawData(map);
            result.setAction(action);
        }
        //构造智能文档链接
        if (Objects.equals(AthenaMessageTypeEnum.LINKURL.getType(), digiwinAimMessage.getType())) {
            result.setShowSeeMore(true);
            result.setContent("");
            result.setTitle(digiwinAimMessage.getContent().getMsg());
            result.getLabel().setText("");
            action.setRawData(digiwinAimMessage.getAction());
            //构建sso免登Url
            String ssoUrl = buildSsoLinkUrl(locale, iamUserToken, digiwinAimMessage.getContent());
            if (!ObjectUtils.isEmpty(ssoUrl)) {
                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                action.setRequestUrl(ssoUrl);
            }
            result.setAction(action);
        }
        //来自于统一消息中心的消息
        if ("app".equals(digiwinAimMessage.getChannelType())) {
            String msg = digiwinAimMessage.getContent().getMsg();
            if (Objects.nonNull(msg)) {
                //js标签转换为Html标签
                msg = msg.replace("\n", "<br/>");
            }
            result.setTitle(digiwinAimMessage.getContent().getTitle());
            result.setContent(msg);
        }
        return result;
    }


    public static String buildSsoLinkUrl(String locale, String iamUserToken, DigiwinAimMessageContent content) {
        if (ObjectUtils.isEmpty(content)) {
            return "";
        }
        String ssoUrl;
        String routerLink = content.getLinkUrl();
        DigiwinAimMessageContentConfig config = content.getConfig();
        Map<String, Object> params = new HashMap<>();
        params.put("ssoLogin", config.getSsoLogin());
        params.put("ssoAppCode", config.getSsoAppCode());
        params.put("appType", config.getAppType());
        HashMap<String, Object> dynamicParams = new HashMap<>();
        dynamicParams.put("routerLink", routerLink);
        params.put("dynamicParams", dynamicParams);
        DigiwinSemcProxyService digiwinSemcProxyService = SpringContextHolder.getBean(DigiwinSemcProxyService.class);
        JSONObject url = digiwinSemcProxyService.getSsoUrl(locale, iamUserToken, params);
        if(Objects.isNull(config.getSsoLogin())){
            return "";
        }
        if (config.getSsoLogin()) {
            ssoUrl = url.getString("ssoAddress");
        } else {
            ssoUrl = url.getString("address");
        }
        return ssoUrl;
    }

    /**
     * 新增/合并任务消息优化拼接content
     *
     * @param locale
     * @param digiwinAimMessage
     * @param messageFiled
     * @param result
     */
    private static void handleCardSpliceContent(String locale, DigiwinAimMessage digiwinAimMessage, DigiwinAimMessageContentMessageFiled messageFiled, NotificationDetail result) {
        StringBuilder builder = new StringBuilder();
        String category = "";
        if (AthenaNotificationTypeEnum.NEW.name().equals(digiwinAimMessage.getCategory())) {
            category = localeService.getLanguageValue(locale, "新增任务");
        }
        if (AthenaNotificationTypeEnum.UPDATE.name().equals(digiwinAimMessage.getCategory())) {
            category = localeService.getLanguageValue(locale, "更新任务");
        }
        builder.append("<p>");
        builder.append("【").append(category).append("】")
                .append(localeService.getLanguageValue(locale, "预计完成时间"))
                .append("-")
                .append("<span style=\"color: black;\">")
                .append(messageFiled.getEndTime())
                .append("</span>");
        builder.append("<br/>");
        builder.append("</p>");

        builder.append("<p>");
        builder.append(localeService.getLanguageValue(locale, "任务"))
                .append("/");
        builder.append(localeService.getLanguageValue(locale, "项目"))
                .append("-");
        builder.append("<span style=\"font-weight: bold;color: black;\">【")
                .append(messageFiled.getTmActivityName())
                .append("】</span>")
                .append("  ")
                .append("<span style=\"color: black;\">")
                .append(messageFiled.getProjectName())
                .append("</span>");
        builder.append("<br/>");
        builder.append("</p>");

        // 摘要没有值不显示
        if (StringUtils.hasLength(messageFiled.getSummaryLayout())) {
            builder.append(localeService.getLanguageValue(locale, "摘要")).append("-")
                    .append("<span style=\"color: black;\">")
                    .append(messageFiled.getSummaryLayout())
                    .append("</span>");
        }
        result.setContent(builder.toString());
    }

    @Deprecated
    public static NotificationDetail create(String locale, DigiwinAimMessage digiwinAimMessage,
                                            NotificationDetailProjectCard card, String mobileNotificationCategoryId) {
        NotificationDetail result = new NotificationDetail();
        result.setPerson(NotificationPerson.create(locale, digiwinAimMessage,
                AthenaMobileNotificationCategoryEnum.getEnumByName(mobileNotificationCategoryId)));
        result.setCard(card);
        result.setContent(digiwinAimMessage.getContent().getMsg());
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());
        result.setLabel(NotificationLabel.create(locale, digiwinAimMessage));
//        if (digiwinAimMessage.getContent() != null && digiwinAimMessage.getContent().getStartTime() != null && digiwinAimMessage.getContent().getStartTime().contains("T")) {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        } else {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        }
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        result.setTitle(digiwinAimMessage.getTitle());
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setShowPhoto(false);

        return result;
    }

    public static NotificationDetail createPersonal(String locale, DigiwinAimMessage digiwinAimMessage,
                                                    Card card, String mobileNotificationCategoryId) {
        NotificationDetail result = new NotificationDetail();
        result.setPerson(NotificationPerson.create(locale, digiwinAimMessage,
                AthenaMobileNotificationCategoryEnum.getEnumByName(mobileNotificationCategoryId)));
        result.setCard(card);
        result.setTitle(digiwinAimMessage.getContent().getMessageBoard().get(0).getComment());
        // TODO 跳转页面还需要处理
        //        result.setJumpPageId();
//        result.setLabel(NotificationLabel.create(locale, digiwinAimMessage));
//        if (digiwinAimMessage.getContent() != null && digiwinAimMessage.getContent().getStartTime() != null && digiwinAimMessage.getContent().getStartTime().contains("T")) {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        } else {
//            result.setPublishTime(digiwinAimMessage.getCreateDate());
//        }
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());

        return result;
    }

    public static NotificationDetail createAthenaWelcomeDetail(String locale) {
        NotificationDetail notificationDetail = new NotificationDetail();
        notificationDetail.setPerson(NotificationPerson.create(locale, null,
                AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT));
        notificationDetail.setContent(LocaleUtil.getMobileTextByKey(locale, "WELCOME_TO_ATHENA"));
//        notificationDetail.publishTime("");

        return notificationDetail;
    }

    public NotificationPerson getPerson() {
        return person;
    }

    public void setPerson(NotificationPerson person) {
        this.person = person;
    }

    public Card getCard() {
        return card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getJumpPageId() {
        return jumpPageId;
    }

    public void setJumpPageId(String jumpPageId) {
        this.jumpPageId = jumpPageId;
    }

    public NotificationLabel getLabel() {
        return label;
    }

    public void setLabel(NotificationLabel label) {
        this.label = label;
    }

    public String getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(String publishTime) {
        //todo  时间
        if (null == publishTime || "".equals(publishTime.trim())) {
            this.publishTime = DateTimeUtil.MIN_DATETIME_USE_DEFAULT_PATTERN;
        } else {
            this.publishTime = publishTime;
        }
    }

    public String getTitle() {
        return StringUtil.applyLineFeed(title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDataId() {
        return dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Boolean getShowPhoto() {
        return showPhoto;
    }

    public void setShowPhoto(Boolean showPhoto) {
        this.showPhoto = showPhoto;
    }

    public Boolean getShowSeeMore() {
        return showSeeMore;
    }

    public void setShowSeeMore(Boolean showSeeMore) {
        this.showSeeMore = showSeeMore;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getGid() {
        return gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public Map<String, Object> getMsgContent() {
        return msgContent;
    }

    public void setMsgContent(Map<String, Object> msgContent) {
        this.msgContent = msgContent;
    }

    public Boolean getTemplateMessage() {
        return isTemplateMessage;
    }

    public void setTemplateMessage(Boolean templateMessage) {
        isTemplateMessage = templateMessage;
    }

    public DigiwinAimMessageExtendContent getExtendDisplayContent() {
        return extendDisplayContent;
    }

    public void setExtendDisplayContent(DigiwinAimMessageExtendContent extendDisplayContent) {
        this.extendDisplayContent = extendDisplayContent;
    }

    public String getNoShowSeeMoreMsg() {
        return noShowSeeMoreMsg;
    }

    public void setNoShowSeeMoreMsg(String noShowSeeMoreMsg) {
        this.noShowSeeMoreMsg = noShowSeeMoreMsg;
    }
}