package com.digiwin.mobile.mobileuibot.notification.model;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;

import java.lang.reflect.Type;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailFastJsonDeserializer
 * @Author: Zaregoto
 * @Date: 2021/7/19 21:01
 */
public class NotificationDetailFastJsonDeserializer implements ObjectDeserializer {

    @Override public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object o) {
        Object parser = defaultJSONParser.parse();
        if (parser instanceof JSONObject) {
            NotificationDetail notificationDetail = new NotificationDetail();

            JSONObject currentJsonObj = (JSONObject) parser;
            JSONObject cardJsonObj = currentJsonObj.getJSONObject("card");
            if (cardJsonObj.containsKey("startTime")) {
                NotificationDetailProjectCard projectCard = cardJsonObj.toJavaObject(NotificationDetailProjectCard.class);
                notificationDetail.setCard(projectCard);
            } else {
                NotificationDetailPersonalCard personalCard = cardJsonObj.toJavaObject(NotificationDetailPersonalCard.class);
                notificationDetail.setCard(personalCard);
            }
            notificationDetail.setPerson(currentJsonObj.getJSONObject("person").toJavaObject(NotificationPerson.class));
            notificationDetail.setContent(currentJsonObj.getString("content"));
            notificationDetail.setLabel(currentJsonObj.getJSONObject("label").toJavaObject(NotificationLabel.class));
            notificationDetail.setPublishTime(currentJsonObj.getString("publishTime"));
            notificationDetail.setTitle(currentJsonObj.getString("title"));
            notificationDetail.setDataId(currentJsonObj.getString("dataId"));

            return (T) notificationDetail;
        }
        return null;
    }

    @Override public int getFastMatchToken() {
        return 0;
    }
}
