package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.cardnormal.Card;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import org.apache.commons.lang3.BooleanUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：通知详情中个人消息摘要卡片的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailPersonalCard
 * @Author: Zaregoto
 * @Date: 2021/4/25 14:17
 */
public class NotificationDetailPersonalCard extends Card implements Serializable {
    private static final long serialVersionUID = 2234508043091108465L;

    private String content;
    private Action action;
    /**
     * 是否显示查看更多
     */
    private Boolean showSeeMore;

    /**
     * 创建个人消息的详情卡片
     *
     * @param locale
     * @param iamUserToken
     * @param digiwinAtmcProject
     * @param aimMessageRelatedType 消息关联的对象类型。值为task时表示项目，值为activity时表示任务
     * @return
     */
    public static NotificationDetailPersonalCard create(String locale, String iamUserToken,
                                                        DigiwinAtmcProject digiwinAtmcProject, String aimMessageRelatedType,
                                                        List<TaskFilter> filterList) {
        if (null == digiwinAtmcProject) {
            return null;
        } else {
            NotificationDetailPersonalCard card = new NotificationDetailPersonalCard();
            List<DigiwinAtmcTask> tasks = digiwinAtmcProject.getTasks();
            String titlePrefix = LocaleUtil.getMobileTextByKey(locale, "需完成");
            String titleTemplate = "%s %s";
            if (!tasks.isEmpty()) {
                card.setTitle(String.format(titleTemplate, titlePrefix, tasks.get(0).getName()));
            } else {
                card.setTitle(String.format(titleTemplate, titlePrefix, digiwinAtmcProject.getName()));
            }
            card.setContent(ProjectStringUtil.getProjectNameOnCard(locale, digiwinAtmcProject.getStartTime(),
                    digiwinAtmcProject.getEndTime(), digiwinAtmcProject.getName(), false));

            bindActionToCard(card, digiwinAtmcProject, aimMessageRelatedType, filterList);

            return card;
        }
    }

    /**
     * 创建个人消息的详情卡片
     *
     * @param locale
     * @param iamUserToken
     * @param digiwinAtmcBacklogDetail
     * @param aimMessageRelatedType    消息关联的对象类型。值为task时表示项目，值为activity时表示任务
     * @param pageTaskRelationList
     * @return
     */
    public static NotificationDetailPersonalCard create(String locale, String iamUserToken,
                                                        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                                        DigiwinAimMessage aimMessage,
                                                        List<PageTaskRelation> pageTaskRelationList,
                                                        List<TaskFilter> filterList, String tenantId, String tenantVersion) {
        if (null == digiwinAtmcBacklogDetail) {
            return null;
        } else {
            NotificationDetailPersonalCard card = new NotificationDetailPersonalCard();
            String titlePrefix = LocaleUtil.getMobileTextByKey(locale, "需完成");
            String titleTemplate = "%s %s";
            card.setTitle(String.format(titleTemplate, titlePrefix, digiwinAtmcBacklogDetail.getName()));
            card.setContent(ProjectStringUtil.getProjectNameOnCard(locale, digiwinAtmcBacklogDetail.getBackLogStartTime(),
                    digiwinAtmcBacklogDetail.getEndTime(), digiwinAtmcBacklogDetail.getName(), false));

            bindActionToCard(card, digiwinAtmcBacklogDetail, aimMessage, pageTaskRelationList, filterList, tenantId, tenantVersion);

            return card;
        }
    }

    private static void bindActionToCard(NotificationDetailPersonalCard card,
                                         DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                         DigiwinAimMessage aimMessage, List<PageTaskRelation> pageTaskRelationList,
                                         List<TaskFilter> filterList, String tenantId, String tenantVersion) {
        String aimMessageRelatedType = aimMessage.getType();
        Action action = new Action();
        if ("task".equalsIgnoreCase(aimMessageRelatedType)) {
            card.setShowSeeMore(false);
            // TODO 消息详情个人卡片只会收到任务消息，所以这里留空不处理
        } else if ("activity".equalsIgnoreCase(aimMessageRelatedType)) {
            if (digiwinAtmcBacklogDetail == null || digiwinAtmcBacklogDetail.getId() == null) {
                card.setShowSeeMore(false);
                return;
            }
            // FIXME 如果是非签核型任务的通知卡片，这里跳转后界面就会有问题了
            TaskFilterService taskFilterService = SpringContextHolder.getBean(TaskFilterService.class);
            if (taskFilterService.isSupportedTaskByDigiwinAtmcBacklogDetail(digiwinAtmcBacklogDetail, filterList)) {
                ActivityFilterService activityFilterService = SpringContextHolder.getBean(ActivityFilterService.class);

                Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                        pageTaskRelationList.stream().filter(
                                        pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                                digiwinAtmcBacklogDetail.getTmTaskId(), digiwinAtmcBacklogDetail.getTmActivityId()))
                                .findFirst();
                Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                                pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                        digiwinAtmcBacklogDetail.getTmPattern(), digiwinAtmcBacklogDetail.getTmCategory()))
                        .findFirst();

                String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                        optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                        (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");

                // 如果是正在转V2的任务,区分跳v1还是v2的详情页
                if (TestV1ToV2Util.activityIdMatch(digiwinAtmcBacklogDetail.getTmActivityId())) {
                    if (TestV1ToV2Util.modelTypeMatch()) {
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.toString());
                    } else {
                        action.setJumpPageId(jumpPageId);
                    }
                } else if (BooleanUtils.isTrue(activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(digiwinAtmcBacklogDetail.getAppCode(), digiwinAtmcBacklogDetail.getTmActivityId(), MobileDesignerConfigTypeEnum.TASK.getValue(), tenantId, tenantVersion))) {
                    // 如果是v2的JumpPageId指定为MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.toString());
                } else if (TaskStringUtil.isBizApproval(digiwinAtmcBacklogDetail.getTmPattern(), digiwinAtmcBacklogDetail.getTmCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.toString());
                    card.setShowSeeMore(true);
                } else if (TaskStringUtil.isBizReport(digiwinAtmcBacklogDetail.getTmPattern(), digiwinAtmcBacklogDetail.getTmCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString());
                    card.setShowSeeMore(true);
                } else {
                    action.setJumpPageId(jumpPageId);
                    card.setShowSeeMore(true);
                }
                action.setDataId(digiwinAtmcBacklogDetail.getBacklogId() + "");
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
                // FIXME 不知道这个类型是否OK，可能会引起页面打开时的数据异常
                apiExtraParameter.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue() + "");
                apiExtraParameter.setAppCode(digiwinAtmcBacklogDetail.getAppCode());
                apiExtraParameter.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
                apiExtraParameter.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
                apiExtraParameter.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
                apiExtraParameter.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
                Map<String, Object> rawData = new HashMap<>();
                rawData.put("extraParameter", apiExtraParameter);
                rawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                if (AthenaNotificationTypeEnum.SIGN_NOTICE.toString().equals(aimMessage.getCategory())) {
                    // 签核知会默认就是share方式
                    rawData.put("isShared", true);
                }
                action.setRawData(rawData);
            } else {
                Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                        pageTaskRelationList.stream().filter(
                                        pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                                digiwinAtmcBacklogDetail.getTmTaskId(), digiwinAtmcBacklogDetail.getTmActivityId()))
                                .findFirst();
                Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                                pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                        digiwinAtmcBacklogDetail.getTmPattern(), digiwinAtmcBacklogDetail.getTmCategory()))
                        .findFirst();
                action.setJumpPageId(optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                        optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                        (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : ""));
                card.setShowSeeMore(true);
                action.setDataId(digiwinAtmcBacklogDetail.getBacklogId() + "");
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
                // FIXME 不知道这个类型是否OK，可能会引起页面打开时的数据异常
                apiExtraParameter.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue() + "");
                apiExtraParameter.setAppCode(digiwinAtmcBacklogDetail.getAppCode());
                apiExtraParameter.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
                apiExtraParameter.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
                apiExtraParameter.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
                apiExtraParameter.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
                Map<String, Object> rawData = new HashMap<>();
                rawData.put("extraParameter", apiExtraParameter);
                rawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                if (AthenaNotificationTypeEnum.SIGN_NOTICE.toString().equals(aimMessage.getCategory())) {
                    // 签核知会默认就是share方式
                    rawData.put("isShared", true);
                }
                action.setRawData(rawData);
            }
            card.setAction(action);
        } else {
            // TODO 没有匹配的类型，什么都不做
            card.setShowSeeMore(false);
        }

    }

    private static void bindActionToCard(NotificationDetailPersonalCard card,
                                         DigiwinAtmcProject digiwinAtmcProject, String aimMessageRelatedType,
                                         List<TaskFilter> filterList) {
        List<DigiwinAtmcTask> tasks = digiwinAtmcProject.getTasks();
        Action action = new Action();
        if ("task".equalsIgnoreCase(aimMessageRelatedType)) {
            card.setShowSeeMore(false);
            // TODO 消息详情个人卡片只会收到任务消息，所以这里留空不处理
        } else if ("activity".equalsIgnoreCase(aimMessageRelatedType)) {
            if (tasks.isEmpty()) {
                card.setShowSeeMore(false);
                return;
            }
            DigiwinAtmcTask digiwinAtmcTask = tasks.get(0);
            // FIXME 如果是非签核型任务的通知卡片，这里跳转后界面就会有问题了
            TaskFilterService taskFilterService = SpringContextHolder.getBean(TaskFilterService.class);
            if (taskFilterService.isSupportedTaskByDigiwinAtmcTask(digiwinAtmcTask, filterList)) {
                if (TaskStringUtil.isBizApproval(digiwinAtmcTask.getTmPattern(), digiwinAtmcTask.getTmCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.toString());
                    card.setShowSeeMore(true);
                } else if (TaskStringUtil.isBizReport(digiwinAtmcTask.getTmPattern(), digiwinAtmcTask.getTmCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString());
                    card.setShowSeeMore(true);
                } else {
                    action.setJumpPageId("");
                    card.setShowSeeMore(true);
                }
                action.setDataId(digiwinAtmcTask.getBacklogId() + "");
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
                // FIXME 不知道这个类型是否OK，可能会引起页面打开时的数据异常
                apiExtraParameter.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue() + "");
                apiExtraParameter.setAppCode(digiwinAtmcProject.getAppCode());
                apiExtraParameter.setTmActivityId(digiwinAtmcTask.getTmActivityId());
                apiExtraParameter.setTmCategory(digiwinAtmcTask.getTmCategory());
                apiExtraParameter.setTmPattern(digiwinAtmcTask.getTmPattern());
                apiExtraParameter.setTmTaskId(digiwinAtmcTask.getTmTaskId());
                Map<String, Object> rawData = new HashMap<>();
                rawData.put("extraParameter", apiExtraParameter);
                action.setRawData(rawData);
            }
            card.setAction(action);
        } else {
            // TODO 没有匹配的类型，什么都不做
            card.setShowSeeMore(false);
        }

    }

    public NotificationDetailPersonalCard() {
    }

    public NotificationDetailPersonalCard(String title) {
        super(title);
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Boolean getShowSeeMore() {
        return showSeeMore;
    }

    public void setShowSeeMore(Boolean showSeeMore) {
        this.showSeeMore = showSeeMore;
    }
}
