package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.core.component.card.cardnormal.Card;
import com.digiwin.mobile.mobileuibot.core.component.progress.Progress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;

import java.io.Serializable;

/**
 * <p>功能描述：通知详情中项目摘要卡片的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailProjectCard
 * @Author: Zaregoto
 * @Date: 2021/4/25 14:17
 */
@Deprecated
public class NotificationDetailProjectCard extends Card implements Serializable {
    private static final long serialVersionUID = 2234508043091108465L;

    private String startTime;
    private String endTime;
    private Progress progressData;
    private NotificationDetailProjectCardDetail detail;
    // 0-正常，1-异常
    private Integer state;

    public static NotificationDetailProjectCard create(String locale, String iamUserToken,
                                                       DigiwinAtmcProject digiwinAtmcProject) {
        if (null == digiwinAtmcProject) {
            return null;
        } else {
            NotificationDetailProjectCard card = new NotificationDetailProjectCard();
            card.setStartTime(digiwinAtmcProject.getStartTime());
            card.setEndTime(digiwinAtmcProject.getEndTime());
            card.setTitle(digiwinAtmcProject.getName());
            card.setDetail(NotificationDetailProjectCardDetail.create(locale, iamUserToken, digiwinAtmcProject));
            if (digiwinAtmcProject.getOverdue() || digiwinAtmcProject.getEmergency() != 0 ||
                    digiwinAtmcProject.getChanged()) {
                card.setState(1);
            } else {
                card.setState(0);
            }

            return card;
        }
    }

    public NotificationDetailProjectCard() {
    }

    public NotificationDetailProjectCard(String title) {
        super(title);
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Progress getProgressData() {
        return progressData;
    }

    public void setProgressData(Progress progressData) {
        this.progressData = progressData;
    }

    public NotificationDetailProjectCardDetail getDetail() {
        return detail;
    }

    public void setDetail(NotificationDetailProjectCardDetail detail) {
        this.detail = detail;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
}
