package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;


/**
 * <p>功能描述：通知详情中项目摘要卡片内详情内任务的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailProjectCardDetailItem
 * @Author: Zaregoto
 * @Date: 2021/4/28 11:56
 */
@Deprecated
public class NotificationDetailProjectCardDetailItem implements Serializable {
    private static final long serialVersionUID = -2178128406507897744L;

    private String title;
    private List<String> marks = new ArrayList<>();
    // 只有任务异常的时候给值
    private String url;


    @Deprecated
    public static List<NotificationDetailProjectCardDetailItem> create(String locale,
                                                                       String iamUserToken, DigiwinAtmcProject digiwinAtmcProject) {

        String urlTemplate = AppContext.getBaseUrl()
                + "/mobile/v1/project/task/abnormalreason/list?"
                + "iamUserToken=%s&locale=%s&projectId=%s&tmActivityId=%s";
        List<NotificationDetailProjectCardDetailItem> items = new ArrayList<>(digiwinAtmcProject.getTaskCount());
        for (DigiwinAtmcTask atmcTask : digiwinAtmcProject.getTasks()) {
            String prefix = LocaleUtil.getMobileTextByKey(locale, "已逾期");
            String amount = "";
            String unitText = "";
            String mark = "";

            NotificationDetailProjectCardDetailItem item = new NotificationDetailProjectCardDetailItem();
            item.setTitle(atmcTask.getSubName() + atmcTask.getName());
            if (Optional.ofNullable(atmcTask.getOverdue()).orElse(false)) {
                // 如果数据表示超时，依day,hour,minute的优先顺序展示。哪个大于0则优先展示
                if (atmcTask.getOverdueDays() > 0) {
                    amount = atmcTask.getOverdueDays() + "";
                    unitText = LocaleUtil.getMobileTextByKey(locale, "天");
                } else if (atmcTask.getOverdueHours() > 0) {
                    amount = atmcTask.getOverdueHours() + "";
                    unitText = LocaleUtil.getMobileTextByKey(locale, "小时");
                    item.addMark(String.format(prefix, atmcTask.getOverdueHours()));
                } else {
                    amount = atmcTask.getOverdueMinutes() + "";
                    unitText = LocaleUtil.getMobileTextByKey(locale, "分钟");
                    item.addMark(String.format(prefix, atmcTask.getOverdueMinutes()));
                }
                mark = LocaleUtil.getMobileTextWithUnit(locale, prefix, amount, unitText, false, "");
                item.addMark(mark);
            }
            if (Optional.ofNullable(atmcTask.getException()).orElse(false)) {
                item.setUrl(String.format(urlTemplate,
                        iamUserToken, locale, atmcTask.getProjectId(), atmcTask.getTmActivityId()));
            }

            // TODO 去重 for 0507演示。是否真的是这样的功能需求待讨论
            if (!items.contains(item)) {
                items.add(item);
            }
        }
        return items;
    }

    public NotificationDetailProjectCardDetailItem() {
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getMarks() {
        return marks;
    }

    public void setMarks(List<String> marks) {
        this.marks = marks;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addMark(String mark) {
        if (null != mark && !"".equals(mark)) {
            this.getMarks().add(mark);
        }
    }

    @Override
    public int hashCode() {
        // 参考：https://www.cnblogs.com/yuxiaole/p/9570850.html
        int result = 17;
        result = 31 * result + (title == null ? 0 : title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NotificationDetailProjectCardDetailItem) {
            NotificationDetailProjectCardDetailItem otherItem = (NotificationDetailProjectCardDetailItem) obj;
            return this.getTitle().equals(otherItem.getTitle());
        } else {
            return super.equals(obj);
        }
    }
}
