package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * <p>功能描述：通知内容的前置标签</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationLabel
 * @Author: Zaregoto
 * @Date: 2021/4/21 15:55
 */
public class NotificationLabel implements Serializable {
    private static final long serialVersionUID = -8916553948066495100L;
    private static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

    private String text;
    private String type;

    public static NotificationLabel create(String locale, DigiwinAimMessageSummary digiwinAimMessageSummary) {
        return NotificationLabel.getLabelLocalized(locale, digiwinAimMessageSummary.getMessage().getCategory());
    }

    public static NotificationLabel create(String locale, DigiwinAimMessage digiwinAimMessage) {
        return NotificationLabel.getLabelLocalized(locale, digiwinAimMessage.getCategory());
    }

    @NotNull
    private static NotificationLabel getLabelLocalized(String locale, String messageCategory) {
        String category = messageCategory;
        String text = "";
        /**
         * add by mowj 20221214 平台新增消息type=EOC时，消息分类字段不存在，会导致app端展示时报错。
         * 故此时默认使用鼎捷雅典娜平台的『通知』分类，以免前端报错
         * TODO 未来要由产品规划针对EOC及其他类型消息做设计后完整支持。
         */
        if (!StringUtils.hasLength(category)) {
            category = AthenaNotificationTypeEnum.NOTICE.toString();
        }
        // TODO 这里根据Athena的多语言设置，专门定制了获取多语言中异常/逾期状态
        if (AthenaNotificationTypeEnum.EXCEPTION.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey(locale, "异常");
        } else if (AthenaNotificationTypeEnum.OVERDUE.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey(locale, "逾期");
        } else if (AthenaNotificationTypeEnum.NEW.toString().equals(category)) {
            //迭代23 消息清单的new标签去掉 add by wuyang on 20221116
//                text = AthenaNotificationTypeEnum.NEW.toString();
        } else if (AthenaNotificationTypeEnum.EMERGENCY.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey(locale, "紧急");
        } else if (AthenaNotificationTypeEnum.NOTICE.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey(locale, "通知");
        } else if (AthenaNotificationTypeEnum.PROXY.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey(locale, "代理");
        }  else if (AthenaNotificationTypeEnum.SIGN_NOTICE.toString().equals(category)) {
            text = localeService.getLanguageValue(locale, "知会");
        } else {
            text = "";
        }
        return new NotificationLabel(text, category);
    }

    public static NotificationLabel create(String locale, DigiwinAtmcProject digiwinAtmcProject) {
        NotificationLabel label = new NotificationLabel();
        if (digiwinAtmcProject.getEmergency() != 0) {
            label.setText(LocaleUtil.getMobileTextByKey(locale, "紧急"));
            label.setType(AthenaNotificationTypeEnum.EMERGENCY.toString());
        } else {
            // TODO 变更中的情况好像没数据
        }
        return label;
    }

    public NotificationLabel() {
    }

    public NotificationLabel(String text, String type) {
        this.text = text;
        this.type = type;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
