package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;

import java.io.Serializable;

/**
 * <p>功能描述：通知人员模型，包含实际人员与系统拟人人员</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationPerson
 * @Author: Zaregoto
 * @Date: 2021/4/26 17:36
 */
public class NotificationPerson extends BaseMobileComponentPerson implements Serializable {
    private static final long serialVersionUID = -1406833144584852481L;

    public static NotificationPerson create(String locale, DigiwinAimMessage digiwinAimMessage,
        AthenaMobileNotificationCategoryEnum mobileNotificationCategoryEnum) {
        NotificationPerson person = new NotificationPerson();
        switch (mobileNotificationCategoryEnum) {
            case MOBILE_MY_TODO:
                person.setUserId(AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO.toString());
                person.setName(LocaleUtil.getMobileTextByKey(locale, AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO.toString()));
                break;
            case MOBILE_PROJECT_ASSISTANT:
                person.setUserId(AthenaMobileNotificationCategoryEnum.MOBILE_PROJECT_ASSISTANT.toString());
                person.setName(LocaleUtil.getMobileTextByKey(locale, AthenaMobileNotificationCategoryEnum.MOBILE_PROJECT_ASSISTANT.toString()));
                break;
            case MOBILE_ATHENA_ASSISTANT:
                person.setUserId(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString());
                person.setName(LocaleUtil.getMobileTextByKey(locale, AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
                break;
            case MOBILE_SYSTEM:
                break;
            case MOBILE_INTERNAL_PERSONAL:
                person.setUserId(digiwinAimMessage.getMessageBoardCommenter().getUserId());
                person.setName(digiwinAimMessage.getMessageBoardCommenter().getUserName());
                break;
            default:
                break;
        }

        return person;
    }

    public NotificationPerson() {
    }
}
