package com.digiwin.mobile.mobileuibot.notification.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 推送通知
 *
 * @author wuyang
 * @date 20221009
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PushNotification implements Serializable {
    private static final long serialVersionUID = 2574871584382399368L;
    /**
     * 通知标题:必填
     */
    private String title;
    /**
     * 通知图标：非必填,为空显示默认图标.详细见文档
     */
    private String ico;
    /**
     * 通知图标背景颜色：非必填  可自定义：#ffffff, 为空显示默认背景颜色
     */
    private String icoBGColor;
    /**
     * 通知内容，支持换行。必填
     */
    private String content;
    /**
     * 点击跳转链接，非必填：null-- 通知不可点，其他，点击跳转到对应网页
     */
    private String url;
    /**
     * 详情信息，非必填，url为空时使用。目前仅在Athena使用
     */
    private Map detail;
    /**
     * 租户
     */
    private String tenantId;
    /**
     * 是否发送到iOS生产环境。true:生产环境；false:开发环境
     */
    private Boolean apnsProduction;
}
