package com.digiwin.mobile.mobileuibot.notification.service;

import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetail;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationRemoveResp;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummary;
import com.digiwin.mobile.mobileuibot.notification.model.PushNotification;

import java.io.IOException;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationService
 * @Author: Zaregoto
 * @Date: 2021/4/21 19:08
 */
public interface NotificationService {

    /**
     * 获取通知分类及摘要列表
     *
     * @param clientId
     * @param iamUserToken
     * @param locale
     * @param pageNum
     * @param pageSize
     * @return
     * @throws IOException
     */
    List<NotificationSummary> listNotificationSummaries(final String clientId,
                                                        final String iamUserToken, final String locale,
                                                        Integer pageNum, Integer pageSize) throws IOException;

    /**
     * 根据通知分类，获取通知详情
     *
     * @param clientId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param mobileNotificationCategoryId
     * @param dataId                       通知的业务资料ID
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<NotificationDetail> listNotificationDetailsByCategoryId(final String userId, final String clientId,
                                                                 final String iamUserToken, final String tenantId,
                                                                 final String locale, final String mobileNotificationCategoryId,
                                                                 final String dataId, Integer pageNum, Integer pageSize) throws IOException;

    /**
     * 发送推播给对应的人
     *
     * @param outerUserId
     * @param outerTenantId
     * @param push
     * @param creatorName
     * @param label
     * @return
     */
    Integer pushNotificationToUserId(String outerUserId, String outerTenantId, PushNotification push,
                                     String creatorName, List label);

    /**
     * 一键清除工作提醒
     *
     * @return
     */
    NotificationRemoveResp oneClickRemove();
}
