package com.digiwin.mobile.mobileuibot.notification.strategy;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetail;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetailPersonalCard;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContent;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimNewMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskShare;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.*;

/**
 * <p>功能描述：通知详情以聊天layout来处理的策略服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailChattingStrategy
 * @Author: Zaregoto
 * @Date: 2021/4/25 22:31
 */
@Component("notificationDetailChattingStrategy")
public class NotificationDetailChattingStrategy implements NotificationDetailStrategy {

    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public List<NotificationDetail> listNotificationDetails(String userId, String clientId, String locale,
                                                            String iamUserToken, String tenantId,
                                                            String mobileNotificationCategoryId, String dataId, Integer pageNum, Integer pageSize) throws IOException {
        List<DigiwinAimMessage> digiwinAimMessages = new ArrayList<>();
        //todo
        DigiwinAimNewMessageSummary digiwinAimNewMessageSummary = digiwinAimProxyService.listMessageSummary(locale, iamUserToken, pageNum, pageSize);
        if (digiwinAimNewMessageSummary != null) {
            digiwinAimMessages = digiwinAimNewMessageSummary.getContent();
        }

        List<NotificationDetail> notificationDetails = new ArrayList<>();

        // 如果Athena助手内没有消息，则返回一条内部生成的消息，方法结束
        if (pageNum < 1 && mobileNotificationCategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString())
                && digiwinAimMessages.isEmpty()) {
            notificationDetails.add(NotificationDetail.createAthenaWelcomeDetail(locale));
            return notificationDetails;
        }

        String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List<TaskFilter> filterList = activityFilterService.listValidInAthenaOfTaskFilter(tenantId, tenantVersion);
        List<PageTaskRelation> pageTaskRelationList = activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);
        // 获取定制任务配置列表
        List<CustomTaskConfig> customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();

        // type=eoc时，需要获取用户信息和租户信息
        DigiwinIamUserInfo userInfo = digiwinIamProxyService.userInfoById(userId, iamUserToken, locale);
        Optional<DigiwinIamTenant> tenantOptional =
                digiwinIamProxyService.listUserTenantsInAthena(iamUserToken).stream()
                        .filter(tenant -> tenantId.equals(tenant.getId())).findFirst();

        for (DigiwinAimMessage aimMessage : digiwinAimMessages) {
            NotificationDetail detail = null;
            NotificationDetailPersonalCard personalCard = null;

            // 消息id为空的防护
            boolean msgContentIdEmpty = false;
            if (Optional.ofNullable(aimMessage.getContent()).map(DigiwinAimMessageContent::getId).orElse("").isEmpty()) {
                msgContentIdEmpty = true;
            }
            //获取消息提醒任务卡任务详情数据
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail1 = new DigiwinAtmcBacklogDetail();
            if (AthenaMessageTypeEnum.ACTIVITY.getType().equals(aimMessage.getType())) {
                DigiwinAimMessageContent digiwinAimMessageContent = aimMessage.getContent();
                if (digiwinAimMessageContent != null && StringUtils.hasLength(digiwinAimMessageContent.getShareCode())) {
                    DigiwinAtmcTaskShare digiwinAtmcTaskShare = digiwinAtmcProxyService.getShareTask(locale, iamUserToken, digiwinAimMessageContent.getShareCode());
                    if (digiwinAtmcTaskShare != null && digiwinAtmcTaskShare.getTaskId() != null) {
                        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, digiwinAtmcTaskShare.getTaskId() + "");
                        personalCard = NotificationDetailPersonalCard.create(
                                locale, iamUserToken, digiwinAtmcBacklogDetail, aimMessage, pageTaskRelationList, filterList, tenantId, tenantVersion);
                    }
                }
                if (digiwinAimMessageContent != null && StringUtil.isNotEmpty(digiwinAimMessageContent.getId())) {
                    digiwinAtmcBacklogDetail1 = msgContentIdEmpty ? new DigiwinAtmcBacklogDetail() :
                            this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, aimMessage.getContent().getId());
                    personalCard = NotificationDetailPersonalCard.create(
                            locale, iamUserToken, digiwinAtmcBacklogDetail1, aimMessage, pageTaskRelationList, filterList, tenantId, tenantVersion);
                }
            } else if (AthenaMessageTypeEnum.TASK.getType().equals(aimMessage.getType())) {
                //todo 项目类型暂不支持跳转,应前端还未做出画面
            } else {
                //todo
            }


            detail = NotificationDetail.create(locale, aimMessage, personalCard,
                    mobileNotificationCategoryId, digiwinAtmcBacklogDetail1, customTaskConfigList, iamUserToken);

            // 2023.04.04 增加 type=EOC 构建消息参数
            if (AthenaMessageTypeEnum.EOC.getType().equals(aimMessage.getType())) {
                buildResultByEOC(locale, detail, aimMessage, userInfo, tenantOptional);
            }

            notificationDetails.add(detail);
        }
        /**
         * 配合Flutter上ListView的展示参数reverse=true时，可以自动展示到最底部的的消息。同时需求是最底部展示最新的消息。
         * 经测试验证，给App端返回的数据是依发送时间倒序时，可达到效果。
         */
        notificationDetails.sort((o1, o2) -> {
            LocalDateTime o1NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern(o1.getPublishTime());
            LocalDateTime o2NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern(o2.getPublishTime());
            if (o1NotificationSendDateTime.isBefore(o2NotificationSendDateTime)) {
                return 1;
            } else if (o1NotificationSendDateTime.isEqual(o2NotificationSendDateTime)) {
                return 0;
            } else {
                return -1;
            }
        });

        return notificationDetails;
    }

    /**
     * 构建 EOC消息类型内容
     *
     * @param locale         语言别
     * @param result         封装结构
     * @param aimMessage     aim 消息内容
     * @param userInfo       当前用户信息
     * @param tenantOptional 租户信息
     */
    private void buildResultByEOC(String locale, NotificationDetail result, DigiwinAimMessage aimMessage,
                                  DigiwinIamUserInfo userInfo, Optional<DigiwinIamTenant> tenantOptional) {
        Map<String, Object> msgContent = new HashMap<>();
        result.setMsgContent(msgContent);
        StringBuilder usersb = new StringBuilder();
        if (null != userInfo) {
            usersb.append(userInfo.getName()).append(" ");
        }
        StringBuilder settingMsg = new StringBuilder();
        Object eocMsg = aimMessage.getContent().getEocMsg();
        if (null != eocMsg) {
            List<String> msgList = JsonUtil.objectToJavaObject(eocMsg, new TypeReference<List<String>>() {
            });
            msgList.forEach(msg -> {
                if (StringUtils.hasLength(msg)) {
                    try {
                        String first = msg.substring(0, 1);
                        String second = msg.substring(1, 2);
                        String other = msg.substring(2);
                        settingMsg.append(localeService.getLanguageValue(locale, first))
                                .append(second)
                                .append(localeService.getLanguageValue(locale, other))
                                .append(";");
                    } catch (Exception ignored) {
                    }
                }
            });
        }
        msgContent.put("title", usersb.append(localeService.getLanguageValue(locale, "你好")).append(":").toString());
        msgContent.put("subTitle", new StringBuilder().append(localeService.getLanguageValue(locale, "雅典娜租户"))
                .append("【").append(tenantOptional.map(DigiwinIamTenant::getName).orElse(""))
                .append(" ( ").append(tenantOptional.map(DigiwinIamTenant::getId).orElse("")).append(" )】")
                .append(localeService.getLanguageValue(locale, "当前用户设定不完整"))
                .append(",").append(localeService.getLanguageValue(locale, "请至云控制台完成以下重要设定"))
                .append(": ")
                .append(settingMsg.toString())
                .append(localeService.getLanguageValue(locale, "详见下表明细")).toString());
        msgContent.put("content", Optional.ofNullable(aimMessage.getContent()).map(DigiwinAimMessageContent::getData).orElse(Collections.emptyList()));
        msgContent.put("hint", localeService.getLanguageValue(locale, "友善提醒：未完成上述设定将导致相关用户使用雅典娜过程中发生不可预期的异常"));
        msgContent.put("bottom", localeService.getLanguageValue(locale, "具体详情请通过web端云控制台查看"));
    }

}
