package com.digiwin.mobile.mobileuibot.notification.strategy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>功能描述：通知详情策略工厂</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NotificationDetailStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/4/25 22:35
 */
@Component("notificationDetailStrategyFactory")
public class NotificationDetailStrategyFactory {

    // TODO 改成使用业务key。Spring会自动将Strategy接口的实现类注入到这个Map中，key为bean id，value值则为对应的策略实现类
    @Autowired
    private Map<String, NotificationDetailStrategy> strategyMap;

    public NotificationDetailStrategy get(String beanName) {
        return this.strategyMap.get(beanName);
    }
}
