package com.digiwin.mobile.mobileuibot.ocr;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.image.ImageUtil;
import com.digiwin.mobile.mobileuibot.ocr.model.ApiRequestOcr;
import com.digiwin.mobile.mobileuibot.ocr.model.OcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ocr.service.OcrService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * APP扫码后识别车辆接口
 *
 * @author xujinc
 * @date 2023/6/19 16:04
 */
@RestController
@RequestMapping("/mobile/v1/ocr")
public class OcrController {

    @Autowired
    private OcrService ocrService;

    /**
     * app扫描车牌
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/ocrCarNumber", method = RequestMethod.POST)
    public ApiResponse<OcrCarNumberResult> ocrCarNumber(ApiRequestOcr request) throws IOException {
        OcrCarNumberResult ocrCarNumberResult = null;
        MultipartFile multipartFile = request.getFile();
        byte[] imageBytes = multipartFile.getBytes();
        String base64EncoderImg = ImageUtil.encodeImage(imageBytes);
        ocrCarNumberResult = ocrService.getZtbOcrCarNumber(request, base64EncoderImg);
        if (ApiResponse.ERROR_CODE.equals(ocrCarNumberResult.getCode()) || ApiResponse.SERVICE_ERROR_CODE.equals(ocrCarNumberResult.getCode())) {
            ocrCarNumberResult.getResultMap().put("hasPrompt", true);
            ocrCarNumberResult.getResultMap().put("errorMessage", ocrCarNumberResult.getErrorMsg());
        }
        return ApiResponse.buildOK().setData(ocrCarNumberResult.getResultMap());

    }
}
