package com.digiwin.mobile.mobileuibot.ocr.model;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：ocr返回数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: OcrCarNumberResult
 * @Author: xujinc
 * @Date: 2023/6/19 14:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OcrCarNumberResult implements Serializable {
    private static final long serialVersionUID = -6106711555869374713L;

    private List<OcrCarNumber> carNumbers;

    private Action action;

    private String errorMsg;

    /**
     * OCR识别结果 0:正常，-1：普通异常，-2：
     */
    private String code;

    private Map<String, Object> resultMap = new HashMap<>(1);
}
