package com.digiwin.mobile.mobileuibot.openapi;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.openapi.designer.request.AppPublishVO;
import com.digiwin.mobile.mobileuibot.openapi.service.OpenApiService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：OpenApi 接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: OpenApiController.java
 * @Author: wangjwc
 * @Date: created at 2025/2/7 17:58
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/openapi")
public class OpenApiController {

    @Autowired
    private OpenApiService openApiService;

    /**
     * 应用发版/切板
     */
    @PostMapping(value = "/designer/application/publish")
    public ApiResponse<Map<String, Object>> publish(@RequestBody AppPublishVO publishVO) {
        log.info("设计器应用发版/切板请求参数: {}", JsonUtil.javaObjectToJsonString(publishVO));
        // 增加参数校验，因为appCode不能为空,否则会删除通用的过滤配置
        if (publishVO == null || !StringUtils.hasLength(publishVO.getAppCode())) {
            return ApiResponse.buildError("appCode can not be empty!");
        }
        // 增加参数校验，因为individualCase为true时，ucAppCode不能为空
        if (BooleanUtils.isTrue(publishVO.getIndividualCase()) && !StringUtils.hasLength(publishVO.getUcAppCode())) {
            return ApiResponse.buildError("ucAppCode can not be empty!");
        }
        openApiService.publishOrSwitch(publishVO);
        return ApiResponse.buildOK();
    }

    @PostMapping(value = "/desiginer/dsl/select")
    public Map<String, Object> selectOneDsl(@RequestBody MobileDesignerConfig config) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }

    /**
     * 设计时dsl保存接口 -- test区调试使用(开发平台保存作业调用的是移动测试区接口)，不用每次发版切板
     */
    @PostMapping(value = "/desiginer/dsl/save")
    public Map<String, Object> saveDsl(@RequestBody MobileDesignerConfig config) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        openApiService.updataData(config);
        return result;
    }

    @GetMapping(value = "/desiginer/dsl/delete/{tmActivityId}")
    public Map<String, Object> deleteDsl(@PathVariable(value = "tmActivityId") String tmActivityId) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value = "/desiginer/rule/select/{ruleId}")
    public Map<String, Object> selectOneRule(@PathVariable(value = "ruleId") String ruleId) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value = "/desiginer/rule/selectAll")
    public Map<String, Object> selectAllRule(@RequestParam(name = "code") String code) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }

    @PostMapping(value = "/desiginer/rule/save")
    public Map<String, Object> saveRule(@RequestBody JSONObject rule) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value = "/desiginer/rule/delete/{ruleId}")
    public Map<String, Object> deleteRule(@PathVariable(value = "ruleId") String ruleId) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 0);
        return result;
    }
}
