package com.digiwin.mobile.mobileuibot.openapi.designer.request;

import com.digiwin.mobile.mobileuibot.openapi.designer.enums.AppPublishOperateEnum;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.AppTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：应用发版或切板VO</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PublishOrSwitchVO.java
 * @Author: wangjwc
 * @Date: created at 2025/2/7 14:35
 */
@Data
@Accessors(chain = true)
public class AppPublishVO implements Serializable {
    private static final long serialVersionUID = 5460855836657105880L;
    /**
     * publish：发版，switch：切板
     * @see AppPublishOperateEnum
     */
    private String operate;
    // 应用代号
    private String appCode;
    // 是否个案 true：是，false：否
    private Boolean individualCase = false;
    // 个案应用代号
    private String ucAppCode;

    // -----------------------以下为发版专用参数-----------------------
    /**
     * 应用类型 1：数据驱动1.0,5：数据驱动2.0
     * @see AppTypeEnum
     */
    @Deprecated
    private Integer appType;
    // 是否开启任务定制,true:开启
    private Boolean individualAll = false;
    // 租户ID列表 -- 注意：个案租户为空表示删除所有作业，不重新插入作业
    private List<String> tenantIdList;
    // 任务（执行者）列表
    private List<ActivityVO> taskList;
    // 项目（当责者）列表
    private List<ActivityVO> projectList;
    // 发起项目列表
    private List<ActivityVO> startProjectList;
    // 数据录入/模型驱动列表 -- 根据appType区分
    private List<ActivityVO> dataEntryList;
    // ---------------------------end---------------------------------


    public List<String> getTenantIdList() {
        return tenantIdList = Optional.ofNullable(tenantIdList).orElse(new ArrayList<>());
    }

    public List<ActivityVO> getTaskList() {
        return taskList = Optional.ofNullable(taskList).orElse(new ArrayList<>());
    }

    public List<ActivityVO> getProjectList() {
        return projectList = Optional.ofNullable(projectList).orElse(new ArrayList<>());
    }

    public List<ActivityVO> getStartProjectList() {
        return startProjectList = Optional.ofNullable(startProjectList).orElse(new ArrayList<>());
    }

    public List<ActivityVO> getDataEntryList() {
        return dataEntryList = Optional.ofNullable(dataEntryList).orElse(new ArrayList<>());
    }

    @Data
    public static
    class ActivityVO {
        // 作业code
        private String tmActivityId;
    }
}