package com.digiwin.mobile.mobileuibot.openapi.service;

import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;

import java.util.List;

/**
 * <p>功能描述：设计器作业过滤服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActivityFilterService.java
 * @Author: wangjwc
 * @Date: created at 2025/2/12 11:40
 */
public interface ActivityFilterService {
    /**
     * 获取租户版本
     * @param iamUserToken iam用户token
     * @param tenantId  租户ID
     * @param locale    语言
     * @return String 租户版本
     */
    String tenantVersion(String iamUserToken, String tenantId, String locale);

    /**
     * 获取taskFilter表，找到在Athena中有效的TaskFilter集合
     *
     * @param tenantId 租户ID
     * @param version  数据版本
     * @return List<TaskFilter> 有效的TaskFilter集合
     */
    List<TaskFilter> listValidInAthenaOfTaskFilter(String tenantId, String version);

    /**
     * 获取pageTaskRelation表，找到在Athena中有效的PageTaskRelation集合
     *
     * @param tenantId 租户ID
     * @param version  数据版本
     * @return List<PageTaskRelation> 有效的PageTaskRelation集合
     */
    List<PageTaskRelation> listAthenaOfPageTaskRelations(String tenantId, String version);

    /**
     * 获取mobileDesignerConfig表，对应type下的有效MobileDesignerConfig集合
     *
     * @param type     作业类型 @see MobileDesignerConfigTypeEnum
     * @param tenantId 租户ID
     * @param version  数据版本
     * @return List<MobileDesignerConfig> 有效的MobileDesignerConfig集合
     */
    List<MobileDesignerConfig> findByTypeOfMobileDesignerConfig(String type, String tenantId, String version);

    /**
     * 判断tmActivityId是否存在于mobileDesignerConfig表中
     *
     * @param appCode          应用code
     * @param tmActivityId     作业code
     * @param type     作业类型 @see MobileDesignerConfigTypeEnum
     * @param tenantId 租户ID
     * @param version  数据版本
     * @return Boolean 是否存在
     */
    Boolean isExsitTmActivityIdOfMobileDesignerConfig(String appCode, String tmActivityId, String type, String tenantId, String version);

    /**
     * 根据tmActivityId获取MobileDesignerConfig数据 -- 走本地DSL使用
     *
     * @param appCode          应用code
     * @param tmActivityId     作业code
     * @param type     作业类型 @see MobileDesignerConfigTypeEnum
     * @param tenantId 租户ID
     * @param version  数据版本
     * @return MobileDesignerConfig 数据
     */
    MobileDesignerConfig selectOneData(String appCode, String tmActivityId, String type, String tenantId, String version);
}
