package com.digiwin.mobile.mobileuibot.pattern.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternDetail;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternRequest;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 跳转通用详情页面（任务、项目）
 *
 * @author zhangjj
 * @date 2022/8/18 16:44
 */
@RestController
@RequestMapping("/mobile/v1/pattern")
public class PatternController {

    public static final String JUMP_INFO_SEARCH = "search";

    @Autowired
    private ProjectFilterService projectFilterService;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private CustomTaskConfigService customTaskConfigService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ActivityFilterService activityFilterService;

    /**
     * 跳转通用详情页面（任务、项目）
     *
     * @param request
     * @return
     */
    @PostMapping("/jump/info")
    public ApiResponse<Map> getPatternJumpInfo(@RequestBody PatternRequest request, String type) {
        PatternDetail detail = request.getDetail();
        if (detail == null || !StringUtils.hasLength(detail.getType())
                || !StringUtils.hasLength(detail.getDataId())) {
            return ApiResponse.buildError("Pattern can not be empty!");
        }
        String tenantId = request.getTenantId();
        if (!StringUtils.hasLength(tenantId)) {
            return ApiResponse.buildError("TenantId can not be empty!");
        }
        Action action;
        if (PatternDetail.PATTERN_TYPE_PROJECT.equalsIgnoreCase(detail.getType())) {
            //项目
            action = getProjectAction(request, type);
        } else if (PatternDetail.PATTERN_TYPE_TASK.equalsIgnoreCase(detail.getType())) {
            //任务
            action = getTaskAction(request, type);
        } else if (PatternDetail.PATTERN_TYPE_AGILEDATA_DETAIL.equalsIgnoreCase(detail.getType())) {
            //敏捷数据报表
            action = getAgileDataAction(request, type);
        } else {
            return ApiResponse.buildError("Pattern type is invalid!");
        }

        Map map = new HashMap(1);
        map.put("action", action);
        return ApiResponse.buildOK().setData(map);
    }

    private Action getAgileDataAction(PatternRequest request, String type) {
        Action action = new Action();
        if (JUMP_INFO_SEARCH.equalsIgnoreCase(type)) {
            action = Action.getNoSupportAction(localeService, request.getLocale(), "暂不支持查看该信息详情");
        } else {
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_AGILE_DATA_DETAIL_PAGE.toString());
            action.setDataId(request.getDataId());
            action.setJumpPageTitle("");
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        }
        return action;
    }

    /**
     * 获取项目跳转页面
     *
     * @param request
     * @return
     */
    private Action getProjectAction(PatternRequest request, String type) {
        Action action;
        PatternDetail detail = request.getDetail();
        DigiwinAtmcProject project = new DigiwinAtmcProject();
        DigiwinAtmcCardDetail cardDetail = digiwinAtmcProxyService.getDigiwinAtmcProjectCardDetail(request.getLocale(),
                request.getIamUserToken(), request.getTenantId(), detail.getDataId());
        if (StringUtils.hasLength(detail.getTmTaskId())) {
            project.setTmTaskId(detail.getTmTaskId());
        } else {
            project.setTmTaskId(cardDetail.getTmTaskId());
        }
        if (projectFilterService.isCenterConsoleProject(project, request.getTenantId())) {
            DigiwinAtmcSummaryLayout summaryLayout = cardDetail.getSummaryLayout();
            List<UiBotLayout> layoutList = summaryLayout.getLayout();
            UiBotPageData pageData = summaryLayout.getPageData();
            Map<String, Object> bizData = new HashMap<>();
            for (UiBotLayout layout : layoutList) {
                if (layout.isTypeOfTable()) {
                    List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pageData.get(layout.getSchema());
                    if (!CollectionUtils.isEmpty(bizDataList)) {
                        bizData = bizDataList.get(0);
                    }
                }
            }
            String projectStatus = (String) bizData.get("project_status");
            if ("30".equalsIgnoreCase(projectStatus) || "50".equalsIgnoreCase(projectStatus)) {
                Map<String, Object> rawData = new HashMap<>();
                rawData.put("project_type", cardDetail.getTmTaskId());
                action = new Action(
                        detail.getDataId(), PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL.toString(),
                        "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData);
            } else {
                if (JUMP_INFO_SEARCH.equalsIgnoreCase(type)) {
                    action = Action.getNoSupportAction(localeService, request.getLocale(), "暂不支持查看该项目详情");
                } else {
                    action = getAssistantAction(request.getLocale());
                }
            }
        } else if (projectFilterService.isStandardProject(project, request.getTenantId())) {
            action = new Action(detail.getDataId() + "",
                    PageSettingIdPresetEnum.MOBILE_ATHENA_STANDARD_PROJECT_DETAIL.toString(),
                    "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                    "");
        } else {
            if (JUMP_INFO_SEARCH.equalsIgnoreCase(type)) {
                action = Action.getNoSupportAction(localeService, request.getLocale(), "暂不支持查看该项目详情");
            } else {
                action = getAssistantAction(request.getLocale());
            }

        }
        return action;
    }


    /**
     * 获取任务跳转页面
     *
     * @param request
     * @return
     */
    private Action getTaskAction(PatternRequest request, String type) {
        String tenantVersion = activityFilterService.tenantVersion(request.getIamUserToken(), request.getTenantId(), request.getLocale());
        Action action = new Action<>();
        List<PageTaskRelation> pageTaskRelationList = activityFilterService.listAthenaOfPageTaskRelations(request.getTenantId(), tenantVersion);
        PatternDetail detail = request.getDetail();
        if (!StringUtils.hasLength(detail.getTmActivityId()) || !StringUtils.hasLength(detail.getTmPattern())
                || !StringUtils.hasLength(detail.getTmTaskId()) || !StringUtils.hasLength(detail.getTmCategory())) {
            //fixme 修改调用的接口
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(request.getLocale(), request.getIamUserToken(), detail.getDataId());
            detail.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
            detail.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
            detail.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
            detail.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
            if (digiwinAtmcBacklogDetail.getFinished()) {
                return Action.getNoSupportAction(localeService, request.getLocale(), "已完成任务，暂不支持点击查看");
            }
        }
        Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                pageTaskRelationList.stream().filter(
                                pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                        detail.getTmTaskId(), detail.getTmActivityId()))
                        .findFirst();
        Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                        pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                detail.getTmPattern(), detail.getTmCategory()))
                .findFirst();
        String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
        if ("uibotManualTask".equals(detail.getTmActivityId())) {
            jumpPageId = PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString();
        }

        List<CustomTaskConfig> customTaskConfigList = customTaskConfigService.listCustomTaskConfig();
        Optional<CustomTaskConfig> customTaskConfigOptional = customTaskConfigList.stream()
                .filter(customTaskConfig -> detail.getTmTaskId().equalsIgnoreCase(customTaskConfig.getTmTaskId())
                        && detail.getTmActivityId().equalsIgnoreCase(customTaskConfig.getTmActivityId())).findFirst();
        if (customTaskConfigOptional.isPresent()) {
            CustomTaskConfig customTaskConfig = customTaskConfigOptional.get();
            DigiwinAtmcBacklog digiwinAtmcBacklog = new DigiwinAtmcBacklog();
            digiwinAtmcBacklog.setTmPattern(detail.getTmPattern());
            digiwinAtmcBacklog.setTmTaskId(detail.getTmTaskId());
            digiwinAtmcBacklog.setTmCategory(detail.getTmCategory());
            digiwinAtmcBacklog.setTmActivityId(detail.getTmActivityId());
            digiwinAtmcBacklog.setTenantId(request.getTenantId());
            digiwinAtmcBacklog.setBacklogId(Long.parseLong(detail.getDataId()));

            String requestUrl = customTaskConfig.getCustomTaskUrl(request.getLocale(), request.getIamUserToken(), digiwinAtmcBacklog);
            if (StringUtils.hasLength(requestUrl)) {
                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                action.setRequestUrl(requestUrl);
            } else {
                action = setJumpPageAction(action, jumpPageId, detail);
            }

        } else {
            action = setJumpPageAction(action, jumpPageId, detail);
        }
        if (action.getType() == null) {
            if (JUMP_INFO_SEARCH.equalsIgnoreCase(type)) {
                action = Action.getNoSupportAction(localeService, request.getLocale(), "暂不支持查看该任务详情");
            } else {
                action = getAssistantAction(request.getLocale());
            }
        }
        return action;
    }

    /**
     * 工作提醒列表页Action
     *
     * @param locale
     * @return
     */
    private Action getAssistantAction(String locale) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ASSISTANT.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return action;
    }


    private Action setJumpPageAction(Action action, String jumpPageId, PatternDetail detail) {
        if (StringUtils.hasLength(jumpPageId)) {
            action.setDataId(detail.getDataId());
            action.setJumpPageId(jumpPageId);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            Map<String, String> extraParamete = new HashMap<>(2);
            extraParamete.put("tmActivityId", detail.getTmActivityId());
            extraParamete.put("tmTaskId", detail.getTmTaskId());
            action.setRawData(extraParamete);
        }
        return action;
    }
}
