package com.digiwin.mobile.mobileuibot.pipeline;

import com.google.common.collect.Lists;
import org.springframework.lang.Nullable;

import java.util.Iterator;
import java.util.List;

/**
 * <p>功能描述：管道基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DslGeneratePipeline.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:14
 */
public abstract class AbstractPipeline<T> implements Pipeline<T> {
    /**
     * 管道节点列表
     */
    private final List<PipelineNode<T>> nodes = Lists.newArrayList();

    @Nullable
    private Iterator<PipelineNode<T>> iterator;

    @Override
    public void addPipelineNode(PipelineNode<T> node) {
        nodes.add(node);
    }

    @Override
    public void execute(T t) {
        if (this.iterator == null) {
            this.iterator = this.nodes.iterator();
        }
        if (this.iterator.hasNext()) {
            PipelineNode<T> node = this.iterator.next();
            node.execute(this, t);
        } else {
            reset();
        }
    }

    /**
     * 重置，允许它再次被调用
     */
    private void reset() {
        this.iterator = null;
    }
}
