package com.digiwin.mobile.mobileuibot.pipeline;

/**
 * <p>功能描述：A Pipeline is an object provided to the developer
 * giving a view into the invocation Pipeline of a node for a resource.
 * node use the Pipeline to invoke the next node in the Pipeline, or if the
 * calling node is the last node in the Pipeline, to invoke the resource at the
 * end of the Pipeline.</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Pipeline.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:14
 */
public interface Pipeline<T> {
    /**
     * Causes the next node in the pipeline to be invoked, or if the calling
     * node is the last node in the pipeline , causes the resource at the end of
     * the pipeline to be invoked.
     *
     * @param t the t to pass along the pipeline.
     */
    void execute(T t);

    /**
     * add node to the pipeline
     *
     * @param node the node to add
     */
    void addPipelineNode(PipelineNode<T> node);
}
