package com.digiwin.mobile.mobileuibot.pipeline;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * <p>功能描述：管道工厂类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PipelineFactory.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:32
 */
@Component
public class PipelineFactory implements InitializingBean, ApplicationContextAware {

    private ApplicationContext appContext;

    @Autowired
    private List<PipelineNode> pipelineNodeList;

    /**
     * 管道容器
     */
    private Map<Class<? extends Pipeline>, List<PipelineNode>> pipelineMap = new ConcurrentHashMap<>(8);

    @Override
    public void afterPropertiesSet() throws Exception {
        pipelineMap = pipelineNodeList.stream().collect(Collectors.groupingBy(PipelineNode::getPipeline));
        pipelineMap.keySet().forEach(clazz -> {
            // 具体的管道实体
            Pipeline pipeline = appContext.getBean(clazz);
            pipelineMap.get(clazz).stream()
                    .sorted(Comparator
                            .comparing(PipelineNode::getNodeOrder,
                                    // 降序，因管道节点的执行顺序是从大向小执行
                                    Comparator.reverseOrder()))
                    .forEach(pipeline::addPipelineNode);
        });
    }

    @Override
    public void setApplicationContext(@NotNull ApplicationContext applicationContext)
            throws BeansException {
        this.appContext = applicationContext;
    }

    /**
     * 根据具体的管道class，获取管道实体
     *
     * @param clazz 具体的管道class
     * @return Pipeline
     */
    public <T> Pipeline<T> getPipeline(Class<? extends Pipeline<T>> clazz) {
        return appContext.getBean(clazz);
    }
}
