package com.digiwin.mobile.mobileuibot.pipeline;

/**
 * <p>功能描述：A node is an object that performs handle tasks on either the to a resource </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PipelineNode.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:14
 */
public interface PipelineNode<T> {
    /**
     * The <code>execute</code> method of the node is called by the Pipeline.
     * The Pipeline passed in to this method allows the node to pass on the T to the next entity in the pipeline.
     *
     * @param p Provides access to the next node in the pipeline for this node to pass the T to for further processing
     * @param t The T to process
     */
    void execute(Pipeline<T> p, T t);

    /**
     * 获取对应的管道
     *
     * @return Class
     */
    Class<? extends Pipeline<T>> getPipeline();

    /**
     * 获取节点顺序
     *
     * @return Integer
     */
    Integer getNodeOrder();
}
