package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.PipelineNode;

/**
 * <p>功能描述：DSL生成 管道节点 基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DslGeneratePipelineNode.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:14
 */
public abstract class DslGeneratePipelineNode implements PipelineNode<ApiResponse> {

    /**
     * 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
     *
     * @param p           Provides access to the next node in the pipeline for this node to pass the T to for further processing
     * @param apiResponse The apiResponse to process
     */
    @Override
    public abstract void execute(Pipeline<ApiResponse> p, ApiResponse apiResponse);

    @Override
    public Class<? extends Pipeline<ApiResponse>> getPipeline() {
        return DslGeneratePipeline.class;
    }

    /**
     * 管道节点类型枚举
     *
     * @return DslGeneratePipelineNodeEnum
     */
    public abstract DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum();

    @Override
    public Integer getNodeOrder() {
        return getDslGeneratePipelineNodeEnum().getOrder();
    }

}
