package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsWrapper;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import static com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil.customizeListComponentsMap;

/**
 * <p>功能描述：CustomTabs转对象返回给前端 管道节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabsToObjectPipelineNode.java
 * @Author: yanfeng
 * @Date: created at 2023/7/31
 */
@Slf4j
@Component
public class CustomTabsWrapperPipelineNode extends DslGeneratePipelineNode {

    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";

    @Override
    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.CUSTOM_TABS_OBJECT;
    }

    @Override
    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        // 执行下个管道节点，因管道中的节点是降序排列，故必须放在方法最前面执行
        pipeline.execute(apiResponse);

        // 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
        try {
            if (null == apiResponse) {
                return;
            }
            if (RENDER_PAGE_URI.equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri())) {
                if (ObjectUtils.isNotEmpty(apiResponse.getData())) {
                    UiBotModel uiBotModel = JsonUtil.objectToJavaObject(apiResponse.getData(), new TypeReference<UiBotModel>() {
                    });
                    if (!CollectionUtils.isEmpty(uiBotModel.getLayout())) {
                        for (UiBotLayout layoutToProcess : uiBotModel.getLayout()) {
                            Object rawComponentData = uiBotModel.getPageData().get(layoutToProcess.getSchema());
                            if (null == rawComponentData) {
                                continue;
                            }
                            String type = layoutToProcess.getType();
                            Class<? extends MobileComponent> customizeClazz = customizeListComponentsMap.getOrDefault(type, null);
                            if (null == customizeClazz) {
                                continue;
                            }
                            if (customizeClazz.equals(CustomTabs.class)) {
                                CustomTabs customTabs = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layoutToProcess.getSchema()), CustomTabs.class);
                                CustomTabsWrapper wrapper = new CustomTabsWrapper();
                                wrapper.setData(customTabs);
                                wrapper.setStyle(1);
                                wrapper.setAlignmentType(CustomTabControllerTabAlignEnum.CENTER.getValue());
                                wrapper.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                                wrapper.setDefaultSelected(0);
                                wrapper.setBackgroundColor();
                                uiBotModel.getPageData().put(layoutToProcess.getSchema(), wrapper);
                                apiResponse.setData(uiBotModel);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error("CustomTabsToObjectPipelineNode failure, error:{}", e.getMessage(), e);
        }
    }
}
