package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.config.request.log.RequestResponseLogInterceptor;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>功能描述：网络请求响应日志 管道节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LogRecordPipelineNode.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:41
 */
@Slf4j
@Component
public class LogRecordPipelineNode extends DslGeneratePipelineNode {

    @Autowired
    private HttpServletRequest request;

    @Override
    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.LOG_RECORD;
    }

    @Override
    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        // 执行下个管道节点，因管道中的节点是降序排列，故必须放在方法最前面执行
        pipeline.execute(apiResponse);

        // 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
        try {
            if (null == apiResponse) {
                return;
            }
            apiResponse.setTraceId(TraceIdUtil.get());
            request.setAttribute(RequestResponseLogInterceptor.RESPONSE_BODY, apiResponse);
        } catch (Exception e) {
            log.error("LogRecordPipelineNode failure, error:", e);
        }
    }
}
