package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：mock录制场景 管道节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MockScenePipelineNode.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:41
 */
@Slf4j
@Component
public class MockScenePipelineNode extends DslGeneratePipelineNode {

    @Autowired
    private MockService mockService;

    @Override
    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.MOCK_SCENE;
    }

    @Override
    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        // 执行下个管道节点，因管道中的节点是降序排列，故必须放在方法最前面执行
        pipeline.execute(apiResponse);

        // 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
        try {
            if (null == apiResponse) {
                return;
            }
            // mock 相关逻辑
            OuterMockData outerMockData = MockInterceptor.OUTER_MOCK_DATA.get();
            if (null == outerMockData) {
                return;
            }
            String mockId = outerMockData.getMockId();
            if (MockInterceptor.LOGIN_URI.equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri())) {
                DigiwhaleLoginResponse body = (DigiwhaleLoginResponse) apiResponse.getData();
                // mockid不为空，重新设置录制体验账号信息
                mockId = mockService.settingMockUserInfo(mockId, body);
                body.setMockId(mockId);
                outerMockData.setMockId(mockId);
            }
            outerMockData.setResponse(JsonUtil.javaObjectToJsonString(apiResponse));
        } catch (Exception e) {
            log.error("MockScenePipelineNode failure, error:", e);
        }
    }
}
