package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>功能描述：团队任务和项目的处理 管道节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabsToObjectPipelineNode.java
 * @Author: xujinc
 * @Date: created at 2023/11/10
 */
@Slf4j
@Component
public class TeamTaskPipelineNode extends DslGeneratePipelineNode {

    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";

    @Autowired
    private LocaleService localeService;

    @Override
    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.TEAM_TASK;
    }

    @Override
    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        // 执行下个管道节点，因管道中的节点是降序排列，故必须放在方法最前面执行
        pipeline.execute(apiResponse);

        // 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
        try {
            if (null == apiResponse) {
                return;
            }
            if ((BooleanUtils.isTrue(AppRequestContext.getContextEntity().getIsTeamTask())
                    || BooleanUtils.isTrue(AppRequestContext.getContextEntity().getPinning()))
                    && RENDER_PAGE_URI.equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri())) {
                if (ObjectUtils.isNotEmpty(apiResponse.getData())) {
                    String locale = AppRequestContext.getContextEntity().getLocale();
                    UiBotModel uiBotModel = JsonUtil.objectToJavaObject(apiResponse.getData(), new TypeReference<UiBotModel>() {
                    });

                    List<String> allowDisplayButtonNameList = new ArrayList<>();
                    allowDisplayButtonNameList.add(localeService.getLanguageValue(locale, "取消"));
                    allowDisplayButtonNameList.add(localeService.getLanguageValue(locale, "详情"));

                    if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion())) {
                        uiBotModel = MobileRenderDataUtil.handleV2TeamWork(uiBotModel, allowDisplayButtonNameList);
                    } else {
                        uiBotModel = (UiBotModel) MobileRenderDataUtil.handleV1TeamWork(uiBotModel, null, allowDisplayButtonNameList);
                    }
                    uiBotModel.setAppbarButtonList(Collections.emptyList());
                    apiResponse.setData(uiBotModel);
                }
            }
        } catch (Exception e) {
            log.error("TeamTaskPipelineNode failure, error:", e);
        }
    }
}
