package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Optional;

/**
 * <p>功能描述：V1版本DSL转V2版本DSL 管道节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UpgradeDSLPipelineNode.java
 * @Author: wangjwc
 * @Date: created at 2023/6/26 15:41
 */
@Slf4j
@Component
public class UpgradeDSLPipelineNode extends DslGeneratePipelineNode {

    @Autowired
    private HttpServletRequest request;

    @Override
    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.UPGRADE_DSL;
    }

    @Override
    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        // 执行下个管道节点，因管道中的节点是降序排列，故必须放在方法最前面执行
        pipeline.execute(apiResponse);

        // 必须使用 try 并且不抛出异常。防止抛异常导致主流程响应无法正常返回，且后面节点无法执行
        try {
            if (null == apiResponse) {
                return;
            }
            // 真实请求的Url，作用于 体验模式：V1版本DSL转V2版本DSL
            String requestUri = Optional.ofNullable(request.getAttribute("experience_real_url"))
                    .map(StringUtil::valueOf)
                    .orElse(AppRequestContext.getContextEntity().getRequestUri());
            // 针对正常登录、体验模式，根据请求头参数 V1版本DSL转V2版本DSL
            MobileRenderDataUtil.upgradeToV2(requestUri, apiResponse);
        } catch (Exception e) {
            log.error("UpgradeDSLPipelineNode failure, error:", e);
        }
    }
}
