package com.digiwin.mobile.mobileuibot.portal.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.ApplicationColumnReq;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileAppColumnResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileClassificatonResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileFullBackResp;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/portal")
public class MobilePortalController {

    @Autowired
    private PortalService portalService;

    @Autowired
    private LocaleService localeService;

    private static final Integer MAX_LENGTH = 8;

    /**
     * 查询用户移动门户列表
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/info/userAuth/selectUserPortal")
    public ApiResponse selectUserPortal(@RequestBody ApiRequsetPortal apiRequsetPortal) {

        return ApiResponse.buildOK().setData(portalService.selectUserPortal(apiRequsetPortal));
    }

    /**
     * 查询用户选择门户类型接口
     *
     * @param apiRequsetPortal
     * @return
     */
    /*@PostMapping("/info/getUserPortalType")
    public ApiResponse getUserPortalType(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK();
        }

        return ApiResponse.buildOK().setData(portalService.getUserPortalType(apiRequsetPortal));
    }*/

    /**
     * 记录用户选择门户类型接口
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/addPortalType")
    public ApiResponse addPortalType(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK();
        }

        Boolean flag = portalService.addPortalType(apiRequsetPortal);
        if (flag) {
            return ApiResponse.buildOK().setData(flag);
        }
        return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "您所选择的职能门户权限被收回，无法使用该门户"));
    }


//    /**
//     *增加移动端门户使用记录
//     */
//    @PostMapping("/addUseRecord")
//    public ApiResponse addUserRecord(@RequestBody ApiRequsetPortal apiRequsetPortal){
//       Boolean flag = portalService.addUserRecord(apiRequsetPortal);
//        if(flag){
//            return ApiResponse.buildOK().setData(flag);
//        }
//        return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(),"记录使用门户失败"));
//
//    }

    /**
     * 校验门户信息
     */
    @PostMapping("/check")
    public ApiResponse check(@RequestBody ApiRequsetPortal apiRequsetPortal) {

        return ApiResponse.buildOK().setData(portalService.check(apiRequsetPortal));
    }


//    /**
//     * 保存用户自定义金刚区
//     */
//    @PostMapping("/saveCustomDistrict")
//    public ApiResponse saveCustomDistrict(@RequestBody ApiRequsetPortal apiRequsetPortal){
//        Long mobilePortalId = Long.valueOf(apiRequsetPortal.getDataId());
//        if(ObjectUtils.isEmpty(mobilePortalId)){
//            return ApiResponse.buildError("移动门户id必须要传入");
//        }
//        MobilePortalInfoContentResp contentResp = apiRequsetPortal.getMobilePortalInfoContentResp();
//        //校验参数
//        String error = portalService.checkParam(contentResp);
//        if(StringUtils.isNotBlank(error)){
//            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(),"error"));
//        }
//        portalService.saveCustomDistrict(mobilePortalId,contentResp,apiRequsetPortal);
//        return ApiResponse.buildOK();
//    }


//    /**
//     * 获取用户自定义金刚区
//     */
//    @PostMapping("/getCustomDistrict")
//    public ApiResponse getCustomDistrict(@RequestBody ApiRequsetPortal apiRequsetPortal){
//        Long mobilePortalId = Long.valueOf(apiRequsetPortal.getDataId());
//        Long contentId = apiRequsetPortal.getMobilePortalInfoContentResp().getContentId();
//        if(ObjectUtils.isEmpty(mobilePortalId)){
//            return ApiResponse.buildError("移动门户id必须要传入");
//        }
//        if(ObjectUtils.isEmpty(contentId)){
//            return ApiResponse.buildError("组件id必传");
//        }
//        MobilePortalInfoContentResp contentResp = portalService.getCustomDistrict(mobilePortalId,contentId,apiRequsetPortal);
//        return ApiResponse.buildOK().setData(contentResp);
//    }


    /**
     * 获取自定义应用分类
     */
    @PostMapping("/getClassificationList")
    public ApiResponse getClassificationList(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        apiRequsetPortal.setIsAll(true);
        List<MobileClassificatonResp> result = portalService.getClassificationList(apiRequsetPortal);
        if (ObjectUtils.isEmpty(result)) {
            result = new ArrayList<>();
        }
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 保存自定义栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/saveApplicationColumn")
    public ApiResponse saveApplicationColumn(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "添加的栏目内容不可为空"));
        }
        if (ObjectUtils.isNotEmpty(apiRequsetPortal.getApplicationColumnReq().getName()) && apiRequsetPortal.getApplicationColumnReq().getName().length() > MAX_LENGTH) {
            return ApiResponse.buildError("栏目名称不符合规范");
        }
        JSONObject resp = portalService.saveApplicationColumn(apiRequsetPortal);
        if (null != resp && StringUtil.isNotEmpty(resp.getString("error"))) {
            return ApiResponse.buildError(resp.getString("error"));
        }
        return ApiResponse.buildOK().setData(resp);
    }

    /**
     * 保存自定义栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/saveApplicationColumnNew")
    public ApiResponse saveApplicationColumnNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "添加的栏目内容不可为空"));
        }
        if (ObjectUtils.isNotEmpty(apiRequsetPortal.getApplicationColumnReq().getName()) && apiRequsetPortal.getApplicationColumnReq().getName().length() > MAX_LENGTH) {
            return ApiResponse.buildError("栏目名称不符合规范");
        }
        JSONObject resp = portalService.saveApplicationColumnNew(apiRequsetPortal);
        if (null != resp && StringUtil.isNotEmpty(resp.getString("error"))) {
            return ApiResponse.buildError(resp.getString("error"));
        }
        return ApiResponse.buildOK().setData(resp);
    }

    /**
     * 获取自定义栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/getApplicationColumnList")
    public ApiResponse getApplicationColumnList(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        List<ApplicationColumnReq> columnReqs = portalService.getApplicationColumnList(apiRequsetPortal);
        if (ObjectUtils.isEmpty(columnReqs)) {
            columnReqs = new ArrayList<>();
        }
        return ApiResponse.buildOK().setData(columnReqs);
    }

    /**
     * 获取自定义栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/getApplicationColumnListNew")
    public ApiResponse getApplicationColumnListNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        List<ApplicationColumnReq> columnReqs = portalService.getApplicationColumnListNew(apiRequsetPortal);
        if (ObjectUtils.isEmpty(columnReqs)) {
            columnReqs = new ArrayList<>();
        }
        return ApiResponse.buildOK().setData(columnReqs);
    }

    /**
     * 获取栏目详情
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/getApplicationColumnDetail")
    public ApiResponse getApplicationColumnDetail(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        MobileAppColumnResp result = portalService.getApplicationColumnDetail(apiRequsetPortal);
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 获取栏目详情 -- 默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/getApplicationColumnDetailNew")
    public ApiResponse getApplicationColumnDetailNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        MobileAppColumnResp result = portalService.getApplicationColumnDetailNew(apiRequsetPortal);
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 设置栏目顺序
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/setColumnOrder")
    public ApiResponse setColumnOrder(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty(apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        return ApiResponse.buildOK().setData(portalService.setColumnOrder(apiRequsetPortal));
    }

    /**
     * 设置栏目顺序 -- 默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/setColumnOrderNew")
    public ApiResponse setColumnOrderNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty(apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        return ApiResponse.buildOK().setData(portalService.setColumnOrderNew(apiRequsetPortal));
    }

    /**
     * 删除栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/delColumn")
    public ApiResponse delColumn(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getColumnIds()) || CollectionUtils.isEmpty(apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        return ApiResponse.buildOK().setData(portalService.delColumn(apiRequsetPortal));
    }

    /**
     * 删除栏目 -- 默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/delColumnNew")
    public ApiResponse delColumnNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getColumnIds()) || CollectionUtils.isEmpty(apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "栏目id不能为空"));
        }
        return ApiResponse.buildOK().setData(portalService.delColumnNew(apiRequsetPortal));
    }

    /**
     * 更新栏目状态
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/updateColumnStatus")
    public ApiResponse updateColumnStatus(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq()) || ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getId()) ||
                ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getStatus())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "请传入正确的参数"));
        }

        return ApiResponse.buildOK().setData(portalService.updateColumnStatus(apiRequsetPortal));
    }

    /**
     * 更新栏目状态--默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    @PostMapping("/updateColumnStatusNew")
    public ApiResponse updateColumnStatusNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq()) || ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getId()) ||
                ObjectUtils.isEmpty(apiRequsetPortal.getApplicationColumnReq().getStatus())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "请传入正确的参数"));
        }

        return ApiResponse.buildOK().setData(portalService.updateColumnStatusNew(apiRequsetPortal));
    }


    @PostMapping("/getFullCallBackUrl")
    public ApiResponse getFullCallBackUrl(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty(apiRequsetPortal.getCustomApplicationId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "请传入正确的参数"));
        }
        MobileFullBackResp fullBackResp = portalService.getFullCallBackUrl(apiRequsetPortal);
        //如果没有权限，返回提示语
        if (!fullBackResp.getIsHavePerm()) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "暂无访问权限"));
        }
        return ApiResponse.buildOK().setData(fullBackResp);

    }

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param apiRequsetPortal 请求入参
     * @return 返回
     */
    @PostMapping("/validUserAppAuth")
    public ApiResponse validUserAppAuth(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty(apiRequsetPortal.getCustomApplicationIdList())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequsetPortal.getLocale(), "参数不能为空"));
        }
        return ApiResponse.buildOK().setData(portalService.validUserAppAuth(apiRequsetPortal));
    }

    /**
     * 获取作业池
     * @param apiRequest
     * @return
     */
    @PostMapping("/getClassificationListNew")
    public ApiResponse getClassificationListNew(@RequestBody ApiRequest apiRequest){
        return ApiResponse.buildOK().setData(portalService.getClassificationListNew(apiRequest));
    }
}